#ifndef _VERTEXONEDGE_H_
#define _VERTEXONEDGE_H_

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#include "../meshtype.h"
#include "Vertex.h"
#include "Edge.h"

namespace bamg {

	//classes
	class Triangles;

	class VertexOnEdge {

		public:
			Vertex* v;
			Edge*   be;
			double abcisse;

			//Constructors
			VertexOnEdge( Vertex * w, Edge *bw,double s) :v(w),be(bw),abcisse(s) {}
			VertexOnEdge(){}

			//Operators
			operator double () const { return abcisse;}
			operator Vertex* () const { return v;}  
			operator Edge* () const { return be;}  
			Vertex & operator[](int i) const { return (*be)[i];}

			//Methods
			void SetOnBTh(){v->onBackgroundEdge=this;v->vint=IsVertexOnEdge;}  

			//Inline methods
			inline void Set(const Triangles &,long,Triangles &);  
	};

}
#endif
