#ifndef _TRIANGLES_H_
#define _TRIANGLES_H_

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#include "../meshtype.h"
#include "Metric.h"
#include "SetOfE4.h"
#include "DoubleAndInt4.h"
#include "Direction.h"
#include "Vertex.h"
#include "TriangleAdjacent.h"
#include "Edge.h"
#include "GeometricalVertex.h"
#include "GeometricalEdge.h"
#include "Curve.h"
#include "Triangle.h"
#include "ListofIntersectionTriangles.h"
#include "GeometricalSubDomain.h"
#include "SubDomain.h"
#include "VertexOnGeom.h"
#include "VertexOnVertex.h"
#include "VertexOnEdge.h"
#include "CrackedEdge.h"
#include "QuadTree.h"

namespace bamg {

	//classes
	class Geometry;

	class Triangles {
		public:

			Geometry & Gh;   // Geometry
			Triangles & BTh; // Background Mesh Bth==*this =>no  background 
			long NbRef;      // counter of ref on the this class if 0 we can delete
			long nbvx,nbtx;  // nombre max  de sommets , de  triangles
			long nt,nbv,nbt,nbiv,nbe; // nb of legal triangles, nb of vertex, of triangles, of initial vertices, of edges with reference,
			long NbOfQuad;  // nb of quadrangle 
			long NbSubDomains;
			long NbOutT;    // Nb of oudeside triangle
			long NbOfTriangleSearchFind;
			long NbOfSwapTriangle;
			Vertex* vertices;
			long NbVerticesOnGeomVertex;
			VertexOnGeom * VerticesOnGeomVertex;
			long NbVerticesOnGeomEdge;
			VertexOnGeom * VerticesOnGeomEdge;
			long NbVertexOnBThVertex;
			VertexOnVertex *VertexOnBThVertex;
			long NbVertexOnBThEdge;
			VertexOnEdge *VertexOnBThEdge;
			long NbCrackedVertices;
			long NbCrackedEdges;
			CrackedEdge *CrackedEdges;
			R2 pmin,pmax;    // extrema
			double coefIcoor; // coef to integer Icoor1;
			Triangle* triangles;
			Edge* edges; 
			QuadTree* quadtree;
			Vertex** ordre;
			SubDomain* subdomains;
			ListofIntersectionTriangles lIntTria;

			//Constructors/Destructors
			Triangles(BamgMesh* bamgmesh,BamgOpts* bamgopts);
			Triangles(double* index,double* x,double* y,int nods,int nels);
			Triangles(Triangles &,Geometry * pGh=0,Triangles* pBTh=0,long nbvxx=0 ); //copy operator
			Triangles(const Triangles &,const int *flag,const int *bb,BamgOpts* bamgopts); // truncature
			Triangles(long nbvx,Triangles & BT,BamgOpts* bamgopts,int keepBackVertices=1) :Gh(BT.Gh),BTh(BT) {
				try {GeomToTriangles1(nbvx,bamgopts,keepBackVertices);}
				catch(...) { this->~Triangles(); throw; }
			}
			Triangles(long nbvx,Geometry & G,BamgOpts* bamgopts) :Gh(G),BTh(*this){
				try { GeomToTriangles0(nbvx,bamgopts);}
				catch(...) { this->~Triangles(); throw; }
			}
			~Triangles(); 

			//Operators
			const Vertex & operator[]  (long i) const { return vertices[i];};
			Vertex & operator[](long i) { return vertices[i];};
			const Triangle & operator()  (long i) const { return triangles[i];};
			Triangle & operator()(long i) { return triangles[i];};

			//Methods
			void SetIntCoor(const char * from =0);
			double MinimalHmin() {return 2.0/coefIcoor;}
			double MaximalHmax() {return Max(pmax.x-pmin.x,pmax.y-pmin.y);}
			I2 toI2(const R2 & P) const {
				return  I2( (Icoor1) (coefIcoor*(P.x-pmin.x))
							,(Icoor1) (coefIcoor*(P.y-pmin.y)) );}
			R2 toR2(const I2 & P) const {
				return  R2( (double) P.x/coefIcoor+pmin.x, (double) P.y/coefIcoor+pmin.y);
			}
			void AddVertex(Vertex & s,Triangle * t,Icoor2 *  =0) ;
			void Insert();
			void ForceBoundary();
			void Renumber(BamgOpts* bamgopts);
			void FindSubDomain(int OutSide=0);
			long TriangleReferenceList(long *) const;
			void ShowHistogram() const;
			void ShowRegulaty() const;
			void ReMakeTriangleContainingTheVertex();
			void UnMarkUnSwapTriangle();
			void SmoothMetric(double raisonmax) ;
			void BoundAnisotropy(double anisomax,double hminaniso= 1e-100) ;
			void MaxSubDivision(double maxsubdiv);
			Edge** MakeGeometricalEdgeToEdge();
			void SetVertexFieldOn();  
			void SetVertexFieldOnBTh();
			long SplitInternalEdgeWithBorderVertices();
			void MakeQuadrangles(double costheta);
			int  SplitElement(int choice);
			void MakeQuadTree();
			void NewPoints(Triangles &,BamgOpts* bamgopts,int KeepVertices=1);
			long InsertNewPoints(long nbvold,long & NbTSwap) ; 
			void ReNumberingTheTriangleBySubDomain(bool justcompress=false);
			void ReNumberingVertex(long * renu);
			void SmoothingVertex(int =3,double=0.3);
			Metric MetricAt (const R2 &) const;
			GeometricalEdge* ProjectOnCurve( Edge & AB, Vertex &  A, Vertex & B,double theta, Vertex & R,VertexOnEdge & BR,VertexOnGeom & GR);
			long Number(const Triangle & t) const  { return &t - triangles;}
			long Number(const Triangle * t) const  { return t - triangles;}
			long Number(const Vertex & t) const  { return &t - vertices;}
			long Number(const Vertex * t) const  { return t - vertices;}
			long Number(const Edge & t) const  { return &t - edges;}
			long Number(const Edge * t) const  { return t - edges;}
			long Number2(const Triangle * t) const  {
				return t - triangles;
			}
			Vertex* NearestVertex(Icoor1 i,Icoor1 j) ;
			Triangle* FindTriangleContaining(const I2 & ,Icoor2 [3],Triangle *tstart=0) const;
			void ReadMesh(double* index,double* x,double* y,int nods,int nels);
			void ReadMesh(BamgMesh* bamgmesh, BamgOpts* bamgopts);
			void WriteMesh(BamgMesh* bamgmesh,BamgOpts* bamgopts);
			void ReadMetric(BamgOpts* bamgopts,const double hmin,const double hmax,const double coef);
			void WriteMetric(BamgOpts* bamgopts);
			void AddMetric(BamgOpts* bamgopts);
			void BuildMetric0(BamgOpts* bamgopts);
			void BuildMetric1(BamgOpts* bamgopts);
			void AddGeometryMetric(BamgOpts* bamgopts);
			int  isCracked() const {return NbCrackedVertices != 0;}
			int  Crack();
			int  UnCrack();
			void BuildGeometryFromMesh(BamgOpts* bamgopts=NULL);
			void GenerateMeshProperties() ;
			int  CrackMesh();

		private:
			void GeomToTriangles1(long nbvx,BamgOpts* bamgopts,int KeepVertices=1);// the real constructor mesh adaption
			void GeomToTriangles0(long nbvx,BamgOpts* bamgopts);// the real constructor mesh generator
			void PreInit(long);

	};

}
#endif
