#ifndef _SetOfEdge4_h
#define _SetOfEdge4_h

namespace bamg {

	class SetOfEdges4;

	class Int4Edge{
		friend class SetOfEdges4;
		public:
		long i,j;
		long next; 
	};

	class SetOfEdges4 {

		private:
			long nx,nbax,NbOfEdges;
			long* head; 
			Int4Edge* Edges;

		public:
			SetOfEdges4(long ,long);// nb Edges mx , nb de sommet 
			~SetOfEdges4() {delete [] head; delete [] Edges;}
			long add (long ii,long jj);
			long SortAndAdd (long ii,long jj) {return ii <=jj ? add (ii,jj)  : add (jj,ii) ;}
			long  nb(){return NbOfEdges;}
			long find (long ii,long jj);
			long SortAndFind (long ii,long jj) {return ii <=jj ? find (ii,jj)  : find (jj,ii) ;}
			long i(long k){return Edges[k].i;}
			long j(long k){return Edges[k].j;}
			long newarete(long k){return NbOfEdges == k+1;}

			//operators
			Int4Edge & operator[](long k){return  Edges[k];}
	};
}
#endif 
