#ifndef _LISTOFINTERSECTIONTRIANGLES_H_
#define _LISTOFINTERSECTIONTRIANGLES_H_

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#include "../meshtype.h"
#include "Metric.h"
#include "Vertex.h"
#include "Edge.h"
#include "GeometricalEdge.h"
#include "Triangle.h"

namespace bamg {

	class Triangles;

	class ListofIntersectionTriangles {

		class IntersectionTriangles {
			public: 
				Triangle* t;
				double  bary[3];  // use if t != 0
				R2 x;
				Metric m;
				double s; // curvilinear coordinate 
				double sp;// length of the previous segment in m
				double sn;// length of the next segment in m
		};

		class SegInterpolation {
			public:
				GeometricalEdge * e;
				double sBegin,sEnd; // abscisse of the seg on edge parameter
				double lBegin,lEnd; // length abscisse set in ListofIntersectionTriangles::Length
				int last;// last index  in ListofIntersectionTriangles for this Sub seg of edge

				//Methods
				R2 F(double s){ 
					double c01=lEnd-lBegin, c0=(lEnd-s)/c01, c1=(s-lBegin)/c01;
					if (lBegin>s || s>lEnd){
						throw ErrorException(__FUNCT__,exprintf("lBegin>s || s>lEnd"));
					}
					return e->F(sBegin*c0+sEnd*c1);
				}
		};

		public:

			int MaxSize;
			int Size;
			double len;
			int state;
			IntersectionTriangles * lIntTria;
			int NbSeg;
			int MaxNbSeg;
			SegInterpolation * lSegsI;

			//Constructors/Destructors
			ListofIntersectionTriangles(int n=256,int m=16)
			  : MaxSize(n), Size(0), len(-1),state(-1),lIntTria(new IntersectionTriangles[n]) ,
			  NbSeg(0), MaxNbSeg(m), lSegsI(new SegInterpolation[m]){
				  long int verbosity=0;
				  if (verbosity>9) printf("   construct ListofIntersectionTriangles %i %i\n",MaxSize,MaxNbSeg);
			}
			~ListofIntersectionTriangles(){
				if (lIntTria) delete [] lIntTria,lIntTria=0;
				if (lSegsI) delete [] lSegsI,lSegsI=0;
			} 

			//Operators
			IntersectionTriangles & operator[](int i) {return lIntTria[i];}
			operator int&() {return Size;}

			//Methods
			void  init(){state=0;len=0;Size=0;}
			int   NewItem(Triangle * tt,double d0,double d1,double d2);
			int   NewItem(R2,const Metric & );
			void  SplitEdge(const Triangles & ,const R2 &,const R2  &,int nbegin=0); 
			double Length(); 
			long  NewPoints(Vertex *,long & nbv,long nbvx);
			void  NewSubSeg(GeometricalEdge *e,double s0,double s1){ 
				long int verbosity=0;
				if (NbSeg>=MaxNbSeg) {
					int mneo= MaxNbSeg;
					MaxNbSeg *= 2;
					if (verbosity>3){
						printf("   reshape lSegsI from %i to %i\n",mneo,MaxNbSeg);
					}
					SegInterpolation * lEn =  new SegInterpolation[MaxNbSeg];
					if (!lSegsI || NbSeg>=MaxNbSeg){
						throw ErrorException(__FUNCT__,exprintf("!lSegsI || NbSeg>=MaxNbSeg"));
					}
					for (int i=0;i< NbSeg;i++) 
					 lEn[i] = lSegsI[MaxNbSeg]; // copy old to new            
					delete []  lSegsI; // remove old
					lSegsI = lEn;        
				}
				if (NbSeg) lSegsI[NbSeg-1].last=Size;
				lSegsI[NbSeg].e=e;
				lSegsI[NbSeg].sBegin=s0;
				lSegsI[NbSeg].sEnd=s1;     
				NbSeg++;           
			}
			void ReShape(){ 
				register int newsize = MaxSize*2;
				IntersectionTriangles* nw = new IntersectionTriangles[newsize];
				if (!nw){ throw ErrorException(__FUNCT__,exprintf("!nw"));}
				// recopy
				for (int i=0;i<MaxSize;i++) nw[i] = lIntTria[i];       
				long int verbosity=0;
				if(verbosity>3) printf("   ListofIntersectionTriangles  ReShape Maxsize %i -> %i\n",MaxSize,MaxNbSeg);
				MaxSize = newsize; 
				delete [] lIntTria;// remove old
				lIntTria = nw; // copy pointer
			}
	};

}
#endif
