#ifndef _GEOMETRICALEDGE_H_
#define _GEOMETRICALEDGE_H_

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#include "../meshtype.h"
#include "Edge.h"
#include "GeometricalVertex.h"
#include "GeometricalEdge.h"

namespace bamg {

	//classes
	class Geometry;

	class GeometricalEdge {

		public:
			GeometricalVertex* v[2];
			long ref;
			long CurveNumber;
			R2   tg[2]; // the 2 tangentes (tg[0] =0 => no continuity)
			GeometricalEdge* Adj[2]; 
			int DirAdj[2];
			int flag ;
			GeometricalEdge* link; // if   Cracked() or Equi()

			//Operators
			GeometricalVertex       & operator[](int i){return *v[i];};
			const GeometricalVertex & operator[](int i) const { return *v[i];};
			GeometricalVertex       * operator()(int i){return v[i];};  

			//Methods
			R2 F(double theta) const ; // parametrization of the curve edge
			double R1tg(double theta,R2 &t) const ; // 1/radius of curvature + tangente
			int  Cracked() const {return flag & 1;}
			int  Dup() const { return flag & 32;}
			int  Equi()const {return flag & 2;}
			int  ReverseEqui()const {return flag & 128;}
			int  TgA()const {return flag &4;}
			int  TgB()const {return flag &8;}
			int  Tg(int i) const{return i==0 ? TgA() : TgB();}
			int  Mark()const {return flag &16;}
			int  Required() { return flag & 64;}
			void SetCracked() { flag |= 1;}
			void SetDup()     { flag |= 32;} // not a real edge 
			void SetEqui()    { flag |= 2;}
			void SetTgA()     { flag|=4;}
			void SetTgB()     { flag|=8;}
			void SetMark()    { flag|=16;}
			void SetUnMark()  { flag &= 1007 /* 1023-16*/;}
			void SetRequired() { flag |= 64;}
			void SetReverseEqui() {flag |= 128;}

			//Inline methods
			inline void Set(const GeometricalEdge & rec,const Geometry & Th ,Geometry & ThNew);
	};

}
#endif
