#ifndef _FINDTRIANGLEADJACENT_H_
#define _FINDTRIANGLEADJACENT_H_

#include "../meshtype.h"
#include "../objects/Edge.h"

namespace bamg {

	inline TriangleAdjacent FindTriangleAdjacent(Edge &E){
		Vertex * a = E.v[0];
		Vertex * b = E.v[1];

		Triangle * t = a->t;
		int i = a->vint;
		TriangleAdjacent ta(t,EdgesVertexTriangle[i][0]); // Previous edge
		if (!t || i<0 || i>=3){
			throw ErrorException(__FUNCT__,exprintf("!t || i<0 !! i>=3"));
		}
		if ( a!=(*t)(i)){
			throw ErrorException(__FUNCT__,exprintf("a!=(*t)(i)"));
		}
		int k=0;
		do { // turn around vertex in direct sens (trigo)
			k++;
			if (k>=20000){
				throw ErrorException(__FUNCT__,exprintf("k>=20000"));
			}
			//  in no crack => ta.EdgeVertex(1) == a otherwise ??? 
			if (ta.EdgeVertex(1) ==  a && ta.EdgeVertex(0) ==  b) return ta; // find 
			ta = ta.Adj();
			if (ta.EdgeVertex(0) ==  a && ta.EdgeVertex(1) ==  b) return ta; // find 
			--ta;
		} while (t != (Triangle *)ta);
		throw ErrorException(__FUNCT__,exprintf("FindTriangleAdjacent: triangle not found"));
		return TriangleAdjacent(0,0);//for compiler
	}

}
#endif
