#include "FindTriangle.h"

Int4 FindTriangle(Triangles &Th, Real8 x, Real8 y, double* a,int & inside){
	I2 I = Th.toI2(R2(Min(Max(Th.pmin.x,x),Th.pmax.x),Min(Max(Th.pmin.y,y),Th.pmax.y))); 
	Icoor2 dete[3];
	Triangle & tb = *Th.FindTriangleContaining(I,dete);

	if  (tb.link) 
	  { // internal point in a true triangles
		a[0]= (Real8) dete[0]/ tb.det;
		a[1]= (Real8) dete[1] / tb.det;
		a[2] = (Real8) dete[2] / tb.det;
		inside = 1;	 
		return Th.Number(tb);
	  } 
	else 
	  {
		inside = 0; 
		double aa,bb;
		TriangleAdjacent  ta=CloseBoundaryEdgeV2(I,&tb,aa,bb);	 
		int k = ta;
		Triangle * tc = ta;
		if (!tc->link) 
		  { ta = ta.Adj();
			tc=ta;
			k = ta;
			Exchange(aa,bb);
			if (!tc->link){
				throw ErrorException(__FUNCT__,exprintf("!tc->link"));
			}
		  }
		a[VerticesOfTriangularEdge[k][0]] = aa;
		a[VerticesOfTriangularEdge[k][1]] = bb;
		a[OppositeVertex[k]] = 1- aa -bb;
		return Th.Number(tc);
	  }
}
