#ifndef MESHTYPE_H
#define MESHTYPE_H

#include "objects/R2.h"
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <cmath>
#include <ctime>

namespace bamg {

	//typedefs
	typedef float  Real4;
	typedef double Real8;
	typedef short  Int1;
	typedef short  Int2;
	typedef long   Int4;
	typedef int  Icoor1;  
#if LONG_BIT > 63 //64 bits or more
	typedef long Icoor2;
#else //32 bits
	typedef double Icoor2;
#endif
	typedef P2<Icoor1,Icoor2> I2;
	typedef P2xP2<Int2,Int4>  I2xI2;
	typedef P2<Real8,Real8>   R2;
	typedef P2<Real4,Real8>   R2xR2;

	//Some parameters
	const double  Pi =3.141592653589793238462643383279502884197169399375105820974944592308;
	const float   fPi=3.141592653589793238462643383279502884197169399375105820974944592308;
	const  int    IsVertexOnGeom = 8;
	const  int    IsVertexOnVertex = 16;
	const  int    IsVertexOnEdge = 32;
	static const  Int2 VerticesOfTriangularEdge[3][2] = {{1,2},{2,0},{0,1}};
	static const  Int2 EdgesVertexTriangle[3][2] = {{1,2},{2,0},{0,1}};
	static const  Int2 OppositeVertex[3] = {0,1,2};
	static const  Int2 OppositeEdge[3] =  {0,1,2};
	static const  Int2 NextEdge[3] = {1,2,0};
	static const  Int2 PreviousEdge[3] = {2,0,1};
	static const  Int2 NextVertex[3] = {1,2,0};
	static const  Int2 PreviousVertex[3] = {2,0,1};
#if LONG_BIT > 63
	const  Icoor1 MaxICoor   = 1073741823; // 2^30-1 =111...111 (29 times)
#else
	const  Icoor1 MaxICoor   = 8388608;    // 2^23
#endif
	const  Icoor2 MaxICoor22 = Icoor2(2)*Icoor2(MaxICoor) * Icoor2(MaxICoor) ;

	//template functions
	template<class T> inline T Square (const T &a) { return a*a;} 
	template<class T> inline T Min (const T &a,const T &b){return a < b ? a : b;}
	template<class T> inline T Max (const T &a,const T & b){return a > b ? a : b;}
	template<class T> inline T Abs (const T &a){return a <0 ? -a : a;}
	template<class T> inline double Norme (const T &a){return sqrt(a*a);}
	template<class T> inline void Exchange (T& a,T& b) {T c=a;a=b;b=c;}
	template<class T> inline T Max3 (const T &a,const T & b,const T & c){return Max(Max(a,b),c);}
	template<class T> inline T Min3 (const T &a,const T & b,const T & c){return Min(Min(a,b),c);}

	//Inline functions
	inline int BinaryRand(){
#ifdef RAND_MAX
		const long HalfRandMax = RAND_MAX/2;
		return rand() < HalfRandMax;
#else
		return rand() & 16384; //2^14 (for sun because RAND_MAX is not def in stdlib.h)
#endif
	} 
	inline float  OppositeAngle(float  a){return a<0 ? fPi+a:a-fPi;}
	inline double OppositeAngle(double a){return a<0 ?  Pi+a:a- Pi;}

	Icoor2 inline det(const I2 &a,const I2 & b,const I2 &c){
		register  Icoor2 bax = b.x - a.x ,bay = b.y - a.y; 
		register  Icoor2 cax = c.x - a.x ,cay = c.y - a.y; 
		return  bax*cay - bay*cax;
	}


}
#endif
