#ifndef _GEOMETRICALVERTEX_H_
#define _GEOMETRICALVERTEX_H_

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#include "../meshtype.h"

namespace bamg {

	//classes
	class Geometry;

	class GeometricalVertex : public Vertex { 

		public:
			friend class Geometry;

			int cas;
			GeometricalVertex* link; //  link all the same GeometricalVertex circular (Crack) 

			//Methods
			int  Corner() const {return cas&4;}
			int  Required()const {return cas&6;}// a corner is required
			int  IsThe() const { return link == this;}  
			void SetCorner(){ cas |= 4;}
			void SetRequired(){ cas |= 2;}
			void Set(){cas=0;}
			GeometricalVertex() :cas(0), link(this) {};
			GeometricalVertex* The() {
				if (!link){ throw ErrorException(__FUNCT__,exprintf("!link"));}
				return link;
			}// return a unique vertex

			//Inline methods
			inline void Set(const GeometricalVertex & rec,const Geometry & Gh ,const Geometry & GhNew);
	};

}
#endif
