#ifndef _VERTEX_H_
#define _VERTEX_H_

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#include "../meshtype.h"
#include "Direction.h"
#include "Metric.h"

namespace bamg {

	//classes
	class Triangle;
	class Triangles;
	class VertexOnGeom;
	class VertexOnEdge;

	class Vertex {

		public:
			I2 i;  // integer coordinates
			R2 r;  // real coordinates
			Metric m;
			Int4 ReferenceNumber;
			Direction DirOfSearch;
			Int1 vint;  // the vertex number in triangle; varies between 0 and 2 in t
			union {
				Triangle* t; // one triangle which is containing the vertex
				Int4 color;
				Vertex* to;  // use in geometry Vertex to now the Mesh Vertex associed 
				VertexOnGeom* onGeometry;       // if vint == 8; // set with Triangles::SetVertexFieldOn()
				Vertex* onBackgroundVertex;     // if vint == 16 on Background vertex Triangles::SetVertexFieldOnBTh()
				VertexOnEdge* onBackgroundEdge; // if vint == 32 on Background edge
			};

			//Operators
			operator  I2() const {return i;}             // Cast operator
			operator  const R2 & () const {return r;}    // Cast operator
			operator Metric () const {return m;}         // Cast operator
			Real8 operator()(R2 x) const { return m(x);} // Get x in the metric m

			//methods (No constructor and no destructors...)
			Real8 Smoothing(Triangles & ,const Triangles & ,Triangle  * & ,Real8 =1);
			void  MetricFromHessian(const double Hxx,const double Hyx, const double Hyy, const double smin,const double smax,const double s,const double err,BamgOpts* bamgopts);
			void  Echo();
			int   ref() const { return ReferenceNumber;}

			//inline functions
			inline Int4 Optim(int =1,int =0); 
			inline void Set(const Vertex & rec,const Triangles &,Triangles &);


	};

	//FOR NOW (WARNING)
	inline Vertex* TheVertex(Vertex * a); // for remove crak in mesh 
	double QuadQuality(const Vertex &,const Vertex &,const Vertex &,const Vertex &);
}
#endif
