#ifndef _TRIANGLEADJACENT_H_
#define _TRIANGLEADJACENT_H_

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#include "../meshtype.h"
#include "Vertex.h"

namespace bamg {

	//classes
	class Triangle;

	class TriangleAdjacent {

		public:
			Triangle* t; //pointer toward the triangle
			int  a;      //Edge number

			//Constructors
			TriangleAdjacent() {};
			TriangleAdjacent(Triangle* tt,int  aa): t(tt),a(aa &3) {};

			//Operators
			operator Triangle * () const {return t;}
			operator Triangle & () const {return *t;}
			operator int() const {return a;}
			TriangleAdjacent & operator++(){ a= NextEdge[a]; return *this; }
			TriangleAdjacent operator--(){ a= PreviousEdge[a]; return *this; }

			//Methods
			int swap();

			//Inline methods
			inline TriangleAdjacent  Adj() const ;
			inline void SetAdj2(const TriangleAdjacent& , int =0);
			inline Vertex *  EdgeVertex(const int &) const ;
			inline Vertex *  OppositeVertex() const ;
			inline Icoor2 & det() const;
			inline int Locked() const  ;
			inline int GetAllFlag_UnSwap() const ;
			inline void SetLock();
			inline int MarkUnSwap()  const;
			inline void SetMarkUnSwap();
			inline void SetCracked();
			inline int Cracked() const ;
	};
}
#endif

