#ifndef _GEOMETRY_H_
#define _GEOMETRY_H_

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#include "../meshtype.h"
#include "Vertex.h"
#include "Edge.h"
#include "GeometricalVertex.h"
#include "GeometricalEdge.h"
#include "Curve.h"
#include "Triangle.h"
#include "GeometricalSubDomain.h"
#include "SubDomain.h"
#include "VertexOnGeom.h"
#include "QuadTree.h"

namespace bamg {

   /*CLASS: Geometry{{{1*/
	class Geometry { 

		public:
			Int4 NbRef;     // counter of ref on the this class if 0 we can delete
			Int4 nbvx,nbtx; // maximum number of vertices
			Int4 nbv,nbt,nbiv,nbe; // number of vertices
			Int4 NbSubDomains; // 
			Int4 NbOfCurves;
			GeometricalVertex* vertices;
			Triangle* triangles; 
			GeometricalEdge* edges;
			QuadTree* quadtree;
			GeometricalSubDomain* subdomains;
			Curve* curves;
			R2 pmin,pmax; // extrema
			Real8 coefIcoor;  // coef to integer Icoor1;
			Real8 MaximalAngleOfCorner;

			//Constructor/Destructors
			~Geometry(); 
			Geometry(const Geometry & Gh); //Copy  Operator 
			Geometry(int nbg,const Geometry** ag); // intersection operator 

			//Operators
			const GeometricalVertex & operator[]  (Int4 i) const { return vertices[i];};
			GeometricalVertex & operator[](Int4 i) { return vertices[i];};
			const  GeometricalEdge & operator()  (Int4 i) const { return edges[i];};
			GeometricalEdge & operator()(Int4 i) { return edges[i];}; 

			//Methods
			int empty(){return (nbv ==0) && (nbt==0) && (nbe==0) && (NbSubDomains==0); }
			void Echo();
			I2 toI2(const R2 & P) const {
				return  I2( (Icoor1) (coefIcoor*(P.x-pmin.x))
							,(Icoor1) (coefIcoor*(P.y-pmin.y)) );}
			Real8 MinimalHmin() {return 2.0/coefIcoor;}
			Real8 MaximalHmax() {return Max(pmax.x-pmin.x,pmax.y-pmin.y);}
			void ReadGeometry(BamgGeom* bamggeom, BamgOpts* bamgopts);
			void EmptyGeometry();
			Geometry() {EmptyGeometry();}// empty Geometry
			void AfterRead();
			Geometry(BamgGeom* bamggeom, BamgOpts* bamgopts) {EmptyGeometry();ReadGeometry(bamggeom,bamgopts);AfterRead();}
			Int4 Number(const GeometricalVertex & t) const  { return &t - vertices;}
			Int4 Number(const GeometricalVertex * t) const  { return t - vertices;}
			Int4 Number(const GeometricalEdge & t) const  { return &t - edges;}
			Int4 Number(const GeometricalEdge * t) const  { return t - edges;}
			Int4 Number(const Curve * c) const  { return c - curves;}
			void UnMarkEdges() {for (Int4 i=0;i<nbe;i++) edges[i].SetUnMark();}
			GeometricalEdge *  ProjectOnCurve(const Edge & ,Real8,Vertex &,VertexOnGeom &) const ;
			GeometricalEdge *  Contening(const R2 P,  GeometricalEdge * start) const;
			void WriteGeometry(BamgGeom* bamggeom, BamgOpts* bamgopts);
	};
	/*}}}1*/
	
}
#endif
