/*\file Bamg.c
 *\brief: bamg module.
 */
#include "./Bamg.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;
	int   i;
	int   nods=0; //to be removed
	int   lines,cols;
	BamgOpts bamgopts;
	BamgMesh bamgmesh;
	BamgGeom bamggeom;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&BamgUsage);

	/*create bamg geometry input*/
	BamgGeomInit(&bamggeom);
	FetchData(&bamggeom.NumVertices,mxGetField(BAMGGEOMETRY,0,"NumVertices"));
	FetchData(&bamggeom.Vertices,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"Vertices"));
	FetchData(&bamggeom.NumEdges,mxGetField(BAMGGEOMETRY,0,"NumEdges"));
	FetchData(&bamggeom.Edges,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"Edges"));
	FetchData(&bamggeom.hVertices,&lines,&cols,mxGetField(BAMGGEOMETRY,0,"hVertices"));
	FetchData(&bamggeom.NumCrackedEdges,mxGetField(BAMGGEOMETRY,0,"NumCrackedEdges"));
	FetchData(&bamggeom.CrackedEdges,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"CrackedEdges"));
	FetchData(&bamggeom.NumSubDomains,mxGetField(BAMGGEOMETRY,0,"NumSubDomains"));
	FetchData(&bamggeom.SubDomains,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"SubDomains"));
	if (bamggeom.hVertices && (cols!=1 || lines!=bamggeom.NumVertices)){throw ErrorException(__FUNCT__,exprintf("the size of 'hVertices' should be [%i %i]",bamggeom.NumVertices,1));}

	/*create bamg mesh input*/
	BamgMeshInit(&bamgmesh);
	FetchData(&bamgmesh.NumVertices,mxGetField(BAMGMESH,0,"NumVertices"));
	FetchData(&bamgmesh.Vertices,NULL,NULL,mxGetField(BAMGMESH,0,"Vertices"));
	FetchData(&bamgmesh.NumTriangles,mxGetField(BAMGMESH,0,"NumTriangles"));
	FetchData(&bamgmesh.Triangles,NULL,NULL,mxGetField(BAMGMESH,0,"Triangles"));
	FetchData(&bamgmesh.hVertices,&lines,&cols,mxGetField(BAMGMESH,0,"hVertices"));
	FetchData(&bamgmesh.NumCrackedEdges,mxGetField(BAMGMESH,0,"NumCrackedEdges"));
	FetchData(&bamgmesh.CrackedEdges,NULL,NULL,mxGetField(BAMGMESH,0,"CrackedEdges"));
	if (bamgmesh.hVertices && (cols!=1 || lines!=bamgmesh.NumVertices)){throw ErrorException(__FUNCT__,exprintf("the size of 'hVertices' should be [%i %i]",bamgmesh.NumVertices,1));}

	/*create bamg options input*/
	BamgOptsInit(&bamgopts);
	FetchData(&bamgopts.coef,mxGetField(BAMGOPTIONS,0,"coef"));
	FetchData(&bamgopts.maxsubdiv,mxGetField(BAMGOPTIONS,0,"maxsubdiv"));
	FetchData(&bamgopts.Hessiantype,mxGetField(BAMGOPTIONS,0,"Hessiantype"));
	FetchData(&bamgopts.Metrictype,mxGetField(BAMGOPTIONS,0,"Metrictype"));
	FetchData(&bamgopts.KeepVertices,mxGetField(BAMGOPTIONS,0,"KeepVertices"));
	FetchData(&bamgopts.renumber,mxGetField(BAMGOPTIONS,0,"renumber"));
	FetchData(&bamgopts.power,mxGetField(BAMGOPTIONS,0,"power"));
	FetchData(&bamgopts.errg,mxGetField(BAMGOPTIONS,0,"errg"));
	FetchData(&bamgopts.nbjacobi,mxGetField(BAMGOPTIONS,0,"nbjacobi"));
	FetchData(&bamgopts.NbSmooth,mxGetField(BAMGOPTIONS,0,"NbSmooth"));
	FetchData(&bamgopts.omega,mxGetField(BAMGOPTIONS,0,"omega"));
	FetchData(&bamgopts.maxnbv,mxGetField(BAMGOPTIONS,0,"maxnbv"));
	FetchData(&bamgopts.hmin,mxGetField(BAMGOPTIONS,0,"hmin"));
	FetchData(&bamgopts.hmax,mxGetField(BAMGOPTIONS,0,"hmax"));
	FetchData(&bamgopts.anisomax,mxGetField(BAMGOPTIONS,0,"anisomax"));
	FetchData(&bamgopts.gradation,mxGetField(BAMGOPTIONS,0,"gradation"));
	FetchData(&bamgopts.cutoff,mxGetField(BAMGOPTIONS,0,"cutoff"));
	FetchData(&bamgopts.verbose,mxGetField(BAMGOPTIONS,0,"verbose"));
	FetchData(&bamgopts.splitcorners,mxGetField(BAMGOPTIONS,0,"splitcorners"));
	FetchData(&bamgopts.MaximalAngleOfCorner,mxGetField(BAMGOPTIONS,0,"MaximalAngleOfCorner"));
	FetchData(&bamgopts.metric,&lines,&cols,mxGetField(BAMGOPTIONS,0,"metric"));
	if (bamgopts.metric && (cols!=3 || lines!=bamgmesh.NumVertices)){throw ErrorException(__FUNCT__,exprintf("the size of 'metric' should be [%i %i]",bamgmesh.NumVertices,3));}
	FetchData(&bamgopts.field,&lines,&bamgopts.numfields,mxGetField(BAMGOPTIONS,0,"field"));
	if (bamgopts.field && lines!=bamgmesh.NumVertices){throw ErrorException(__FUNCT__,exprintf("the size of 'field' should be [%i %i]",bamgmesh.NumVertices,bamgopts.numfields));}
	FetchData(&bamgopts.err,NULL,&cols,mxGetField(BAMGOPTIONS,0,"err"));
	if (bamgopts.numfields!=0 && cols!=bamgopts.numfields){throw ErrorException(__FUNCT__,exprintf("the size of 'err' should be the same as 'field'"));}
	BamgOptsCheck(&bamgopts);

	/*!Generate internal degree of freedom numbers: */
	nods=bamgmesh.NumVertices;
	Bamgx(&bamgmesh,&bamggeom,&bamgopts);

	/*write output datasets: */
	WriteData(TRIANGLESOUT,bamgmesh.Triangles,bamgmesh.NumTriangles,4);
	WriteData(VERTICESOUT,bamgmesh.Vertices,bamgmesh.NumVertices,3);
	WriteData(SEGMENTSOUT,bamgmesh.Segments,bamgmesh.NumSegments,3);
	WriteData(SEGMENTSMARKERSOUT,bamgmesh.SegmentsMarkers,bamgmesh.NumSegments,1);
	WriteData(METRICOUT,bamgopts.metric,nods,3);

	/*Free ressources: */
	//do not free any fields of bamgmesh or bamggeom as it has been freed in bamgx

	/*end module: */
	MODULEEND();
}

void BamgUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements,vertices,segments,segmentmarkers,metric]=%s(bamgmesh,bamggeom,bamgoptions);\n",__FUNCT__);
	_printf_("\n");
}
