/*!\file:  BamgOpts.h
 * \brief place holder for optimization function arguments
 */ 

#ifndef BAMGOPTS_H_
#define BAMGOPTS_H_

struct BamgOpts{

	int     iso;
	int     maxnbv;
	double  MaximalAngleOfCorner;
	int     Hessiantype;
	int     Metrictype;
	int     KeepVertices;
	int     renumber;
	double  maxsubdiv;
	double  power;
	double  anisomax;
	int     NbSmooth;
	int     nbjacobi;
	double  omega;
	double  hmin;
	double  hmax;
	double  gradation;
	double  cutoff;
	int     splitcorners;
	int     verbose;
	double*  err;
	double   errg;
	double  coef;
	double* metric;
	double* field;
	int     numfields;

};

void BamgOptsInit(BamgOpts* bamgopts);

void BamgOptsCheck(BamgOpts* bamgopts);

#endif
