/*\file Bamg.c
 *\brief: bamg module.
 */
#include "./Bamg.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;
	int   i;
	int   nods=0; //to be removed
	int   lines,cols;
	BamgOpts bamgopts;
	BamgMesh bamgmesh;
	BamgGeom bamggeom;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&BamgUsage);

	/*create bamg geometry input*/
	BamgGeomInit(&bamggeom);
	FetchData(&bamggeom.NumVertices,mxGetField(BAMGGEOMETRY,0,"NumVertices"));
	FetchData(&bamggeom.Vertices,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"Vertices"));
	FetchData(&bamggeom.NumEdges,mxGetField(BAMGGEOMETRY,0,"NumEdges"));
	FetchData(&bamggeom.Edges,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"Edges"));
	FetchData(&bamggeom.hVertices,&lines,&cols,mxGetField(BAMGGEOMETRY,0,"hVertices"));
	FetchData(&bamggeom.NumCrackedEdges,mxGetField(BAMGGEOMETRY,0,"NumCrackedEdges"));
	FetchData(&bamggeom.CrackedEdges,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"CrackedEdges"));
	FetchData(&bamggeom.NumSubDomains,mxGetField(BAMGGEOMETRY,0,"NumSubDomains"));
	FetchData(&bamggeom.SubDomains,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"SubDomains"));
	if (bamggeom.hVertices && (cols!=1 || lines!=bamggeom.NumVertices)){throw ErrorException(__FUNCT__,exprintf("the size of 'hVertices' should be [%i %i]",bamggeom.NumVertices,1));}

	/*create bamg mesh input*/
	BamgMeshInit(&bamgmesh);
	FetchData(&bamgmesh.NumVertices,mxGetField(BAMGMESH,0,"NumVertices"));
	FetchData(&bamgmesh.Vertices,NULL,NULL,mxGetField(BAMGMESH,0,"Vertices"));
	FetchData(&bamgmesh.NumTriangles,mxGetField(BAMGMESH,0,"NumTriangles"));
	FetchData(&bamgmesh.Triangles,NULL,NULL,mxGetField(BAMGMESH,0,"Triangles"));
	FetchData(&bamgmesh.hVertices,&lines,&cols,mxGetField(BAMGMESH,0,"hVertices"));
	FetchData(&bamgmesh.NumCrackedEdges,mxGetField(BAMGMESH,0,"NumCrackedEdges"));
	FetchData(&bamgmesh.CrackedEdges,NULL,NULL,mxGetField(BAMGMESH,0,"CrackedEdges"));
	if (bamgmesh.hVertices && (cols!=1 || lines!=bamgmesh.NumVertices)){throw ErrorException(__FUNCT__,exprintf("the size of 'hVertices' should be [%i %i]",bamgmesh.NumVertices,1));}

	/*create bamg options input*/
	BamgOptsInit(&bamgopts);
	FetchData(&bamgopts.coef,mxGetField(BAMGOPTIONS,0,"coef"));
	if (bamgopts.coef==0) throw ErrorException(__FUNCT__,exprintf("'coef' should be positive"));
	FetchData(&bamgopts.maxsubdiv,mxGetField(BAMGOPTIONS,0,"maxsubdiv"));
	if (bamgopts.maxsubdiv<1) throw ErrorException(__FUNCT__,exprintf("'maxsubdiv' should be >=1"));
	FetchData(&bamgopts.Hessiantype,mxGetField(BAMGOPTIONS,0,"Hessiantype"));
	if (bamgopts.Hessiantype!=0 && bamgopts.Hessiantype!=1) throw ErrorException(__FUNCT__,exprintf("'Hessiantype' supported options are 0 and 1"));
	FetchData(&bamgopts.Metrictype,mxGetField(BAMGOPTIONS,0,"Metrictype"));
	if (bamgopts.Metrictype!=0 && bamgopts.Metrictype!=1 && bamgopts.Metrictype!=2) throw ErrorException(__FUNCT__,exprintf("'Metrictype' supported options are 0, 1 and 2"));
	FetchData(&bamgopts.KeepVertices,mxGetField(BAMGOPTIONS,0,"KeepVertices"));
	if (bamgopts.KeepVertices!=0 && bamgopts.KeepVertices!=1) throw ErrorException(__FUNCT__,exprintf("'KeepVertices' supported options are 0 and 1"));
	FetchData(&bamgopts.renumber,mxGetField(BAMGOPTIONS,0,"renumber"));
	if (bamgopts.renumber!=0 && bamgopts.renumber!=1 && bamgopts.renumber!=2) throw ErrorException(__FUNCT__,exprintf("'renumber' supported options are 0, 1 and 2"));
	FetchData(&bamgopts.power,mxGetField(BAMGOPTIONS,0,"power"));
	FetchData(&bamgopts.errg,mxGetField(BAMGOPTIONS,0,"errg"));
	if (bamgopts.errg<0) throw ErrorException(__FUNCT__,exprintf("'errg' option should be >0"));
	FetchData(&bamgopts.nbjacobi,mxGetField(BAMGOPTIONS,0,"nbjacobi"));
	if (bamgopts.nbjacobi<=0) throw ErrorException(__FUNCT__,exprintf("'nbjacobi' option should be >0"));
	FetchData(&bamgopts.NbSmooth,mxGetField(BAMGOPTIONS,0,"NbSmooth"));
	if (bamgopts.NbSmooth<=0) throw ErrorException(__FUNCT__,exprintf("'NbSmooth' option should be >0"));
	FetchData(&bamgopts.omega,mxGetField(BAMGOPTIONS,0,"omega"));
	FetchData(&bamgopts.maxnbv,mxGetField(BAMGOPTIONS,0,"maxnbv"));
	if (bamgopts.maxnbv<3) throw ErrorException(__FUNCT__,exprintf("'maxnbv' option should be >3"));
	FetchData(&bamgopts.hmin,mxGetField(BAMGOPTIONS,0,"hmin"));
	if (bamgopts.hmin<=0) throw ErrorException(__FUNCT__,exprintf("'hmin' option should be >0"));
	FetchData(&bamgopts.hmax,mxGetField(BAMGOPTIONS,0,"hmax"));
	if (bamgopts.hmax<=0 || bamgopts.hmax<bamgopts.hmin) throw ErrorException(__FUNCT__,exprintf("'hmax' option should be between 0 and hmin=%g",bamgopts.hmin));
	FetchData(&bamgopts.anisomax,mxGetField(BAMGOPTIONS,0,"anisomax"));
	if (bamgopts.anisomax<1) throw ErrorException(__FUNCT__,exprintf("'anisomax' option should be >=1"));
	FetchData(&bamgopts.gradation,mxGetField(BAMGOPTIONS,0,"gradation"));
	if (bamgopts.gradation<1) throw ErrorException(__FUNCT__,exprintf("'gradation' option should be >=1"));
	FetchData(&bamgopts.cutoff,mxGetField(BAMGOPTIONS,0,"cutoff"));
	FetchData(&bamgopts.verbose,mxGetField(BAMGOPTIONS,0,"verbose"));
	FetchData(&bamgopts.splitcorners,mxGetField(BAMGOPTIONS,0,"splitcorners"));
	FetchData(&bamgopts.MaximalAngleOfCorner,mxGetField(BAMGOPTIONS,0,"MaximalAngleOfCorner"));
	FetchData(&bamgopts.metric,&lines,&cols,mxGetField(BAMGOPTIONS,0,"metric"));
	if (bamgopts.metric && (cols!=3 || lines!=bamgmesh.NumVertices)){throw ErrorException(__FUNCT__,exprintf("the size of 'metric' should be [%i %i]",bamgmesh.NumVertices,3));}
	FetchData(&bamgopts.field,&lines,&bamgopts.numfields,mxGetField(BAMGOPTIONS,0,"field"));
	if (bamgopts.field && lines!=bamgmesh.NumVertices){throw ErrorException(__FUNCT__,exprintf("the size of 'field' should be [%i %i]",bamgmesh.NumVertices,bamgopts.numfields));}
	FetchData(&bamgopts.err,NULL,&cols,mxGetField(BAMGOPTIONS,0,"err"));
	if (bamgopts.numfields!=0 && cols!=bamgopts.numfields){throw ErrorException(__FUNCT__,exprintf("the size of 'err' should be the same as 'field'"));}
	for (i=0;i<bamgopts.numfields;i++) {if (bamgopts.err[i]<=0) throw ErrorException(__FUNCT__,exprintf("'err' option should be >0"));};

	/*!Generate internal degree of freedom numbers: */
	nods=bamgmesh.NumVertices;
	Bamgx(&bamgmesh,&bamggeom,&bamgopts);

	/*write output datasets: */
	WriteData(TRIANGLESOUT,bamgmesh.Triangles,bamgmesh.NumTriangles,4);
	WriteData(VERTICESOUT,bamgmesh.Vertices,bamgmesh.NumVertices,3);
	WriteData(SEGMENTSOUT,bamgmesh.Segments,bamgmesh.NumSegments,3);
	WriteData(SEGMENTSMARKERSOUT,bamgmesh.SegmentsMarkers,bamgmesh.NumSegments,1);
	WriteData(METRICOUT,bamgopts.metric,nods,3);

	/*Free ressources: */
	//do not free any fields of bamgmesh or bamggeom as it has been freed in bamgx

	/*end module: */
	MODULEEND();
}

void BamgUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements,vertices,segments,segmentmarkers,metric]=%s(bamgmesh,bamggeom,bamgoptions);\n",__FUNCT__);
	_printf_("\n");
}
