/*!\file RiftConstraints.h
 * \brief: manage penalties for rifts 
 */


#ifndef _RIFTCONSTRAINTS_H_
#define _RIFTCONSTRAINTS_H_

#include "../objects/objects.h"
#include "../DataSet/DataSet.h"

int RiftConstraints(int* pconverged, int* pnum_unstable_constraints,DataSet* loads,ParameterInputs* inputs,int min_mechanical_constraints,int analysis_type,int sub_analysis_type);

int RiftIsPresent(DataSet* loads);

int IsPreStable(DataSet* loads);

int SetPreStable(DataSet* loads);

int PreConstrain(int* pnum_unstable_constraints,DataSet* loads,ParameterInputs* inputs,int analysis_type_enum);

int Constrain(int* pnum_unstable_constraints,DataSet* loads,ParameterInputs* inputs,int analysis_type_enum);

void FreezeConstraints(DataSet* loads,ParameterInputs* inputs,int analysis_type);

int MaxPenetrationInInputs(DataSet* loads,ParameterInputs* inputs,int analysis_type_enum);

int PotentialUnstableConstraints(DataSet* loads,ParameterInputs* inputs,int analysis_type_enum);

int IsMaterialStable(DataSet* loads,ParameterInputs* inputs,int analysis_type_enum);

int IsFrozen(DataSet* loads);
#endif
