function md=cielomesh2grid(md)
%INPUT function md=cielomesh2grid(md)
%mesh2grid solution

	%timing
	t1=clock;

	analysis='mesh2grid';

	%configure, and initialise data model and parameter defaults:
	SetParameterDefaults;

	%Initialize results
	md.mesh2grid_results=cell(length(md.mesh2grid_parameters),1);

	%Recover domain outline as a contour structure. 
	writefile('contours.exp',md.domainoutline);
	contours=expread('contours.exp',0);
	contours=contours(1); %just keep the outer domain outline.
	delete('contours.exp');
   
	%loop on the number of mesh2grid parameters:
	for i=1:length(md.mesh2grid_parameters),
		parameter=eval(['md.' md.mesh2grid_parameters{i}]);

		%call GriddataMeshToGrid module:
		md.mesh2grid_results{i}=...
			GriddataMeshToGrid( md.elements,md.x,md.y,contours,parameter,md.mesh2grid_cornereast,md.mesh2grid_cornernorth,...
					md.mesh2grid_xposting,md.mesh2grid_yposting,md.mesh2grid_nlines,md.mesh2grid_ncolumns,md.mesh2grid_interpolation{i},...
					md.mesh2grid_filter{i},md.mesh2grid_windowsize);
		
	end


	%timing
	t2=clock;
	disp(sprintf('\n%s\n',['   solution lasted ' num2str(etime(t2,t1)) ' seconds']));
