function h_g =cieloprognostic_core_linear(m,params,inputs,analysis)
%INPUT function rh_g =cieloprognostic_core_linear(m,params,inputs,analysis)

	%recover flag_y_s from m.y_s
	if size(m.y_s,1)==0,
		flag_y_s= 0;
	else
		flag_y_s= 1;
	end

	%stiffness and load generation only:
	params.kflag=1; params.pflag=1;
	params.ktflag=0;

	%system matrices
	[K_gg , p_g , dK_gg]=Emg(m.bgpdt,m.bgpdtb, m.est,m.lst,m.ept,m.mpt,m.geom3,params,inputs,analysis);

	%Reduce tangent matrix from g size to f size
	[K_ff, K_fs] = Reducematrixfromgtof( K_gg, m.G_mn, flag_y_s ); 
	clear K_gg dK_gg
	
	%Reduce load from g size to f size
	[rp_f] = Reducerightside( rp_g, m.G_mn, rK_fs, m.y_s, flag_y_s );
	[clear p_g K_fs

	%Solve	
	[h_f]=Solver(K_ff,p_f,params.solverstring);
	clear K_ff p_f
	
	%Merge back to g set
	h_g= Mergesolvec( h_f, m.G_mn, m.y_s, m.uset); 
	
	if count>2,
		clear h_f
	end
