function rs = runsteps(varargin),
%RUNSTEPS - constructor for runsteps object
%
%   Usage:
%      rs = runsteps(varargin)
%
%   Examples:
%      rs = runsteps;                             %build an empty runsteps object
%      rs = runsteps('../Models/');               %build an empty runsteps object with a given repository
%      rs = runsteps('../Models/','models.AGU.'); %build an empty runsteps object with a given repository and a prefix

if (nargin==0),

	rs.repository='./';
	rs.prefix    ='model.step#';
	rs.steps     =[];
	rs=class(rs,'runsteps');

elseif (nargin==1 & ischar(varargin{1})),

	%Check repository
	if exist(varargin{1},'dir')~=7,
		error(['runsteps constructor error message: repository ' varargin{1} ' is not a directory']),
	end
	rs.repository=varargin{1};
	rs.prefix    ='model.step#';
	rs.steps     =[];
	rs=class(rs,'runsteps');

elseif (nargin==2 & ischar(varargin{1}) & ischar(varargin{2})),

	%Check repository
	if exist(varargin{1},'dir')~=7,
		error(['runsteps constructor error message: repository ' varargin{1} ' is not a directory']),
	end
	rs.repository=varargin{1};
	rs.prefix    =varargin{2};
	rs.steps     =[];
	rs=class(rs,'runsteps');

else

	help runsteps
	error('runsteps constructor error message: bad usage')

end
