function md=loadmodel(rs,step,varargin),
%LOADMODEL - save model for a given step
%
%   Usage:
%      md=loadmodel(rs,num,varargin)
%
%   Examples:
%      md=loadmodel(rs,num)
%      md=loadmodel(rs,num,'2d')

%check inputs
if (nargin<2 | nargin>3),
	help loamodel
	error('loadmodel error message: bad usage');
end

%Get id
if ischar(step),
	id=GetId(rs,step);
else
	id=step;
end

%check rs length
if (id>length(rs.steps)),
	error(['runsteps error message: element with id ' num2str(num) ' not found']);
end

%get type if provided
if nargin~=3
	path=[rs.repository '/' rs.prefix num2str(id)];
elseif ischar(varargin{1}),
	path=[rs.repository '/' rs.prefix num2str(id) '.' varargin{1} ];
else
	error('loadmodel error message: third argument should be a string');
end

%load model
md=loadmodel(path);
