/*!\file SurfaceAreax
 * \brief: compute Surface area
 */

#include "./SurfaceAreax.h"

#undef __FUNCT__ 
#define __FUNCT__ "SurfaceAreax"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void SurfaceAreax( double* pS, DataSet* elements,DataSet* nodes, DataSet* loads, DataSet* materials,DataSet* parameters,
			ParameterInputs* inputs,int analysis_type,int sub_analysis_type){
	
	/*output: */
	double S;
	double S_sum;
	
	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes, materials,parameters);
	parameters->Configure(elements,loads, nodes, materials,parameters);

	/*Compute gradients: */
	elements->SurfaceArea(&S,inputs,analysis_type,sub_analysis_type);

	/*Sum all J from all cpus of the cluster:*/
	MPI_Reduce (&S,&S_sum,1,MPI_DOUBLE,MPI_SUM,0,MPI_COMM_WORLD );
	MPI_Bcast(&S_sum,1,MPI_DOUBLE,0,MPI_COMM_WORLD); 
	S=S_sum;

	/*Assign output pointers: */
	*pS=S;
}
