/*!\file Dux
 * \brief: diff between observed and modeled velocity
 */

#include "./Dux.h"

#undef __FUNCT__ 
#define __FUNCT__ "Dux"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../SurfaceAreax/SurfaceAreax.h"

void Dux( Vec* pdu_g, DataSet* elements,DataSet* nodes, DataSet* loads, DataSet* materials, DataSet* parameters,
			ParameterInputs* inputs,int analysis_type,int sub_analysis_type){

	/*Intermediary*/
	int i;
	int gsize;
	int found;
	double fit=-1;
	double S;

	/*output: */
	Vec du_g=NULL;

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes, materials,parameters);
	parameters->Configure(elements,loads, nodes, materials,parameters);

	/*If fit=3, compute Surface Area*/
	if(!inputs->Recover("fit",&fit)) throw ErrorException(__FUNCT__," missing fit input parameter");
	if (fit==3 && !inputs->IsPresent("surfacearea")){

		SurfaceAreax(&S,elements,nodes,loads,materials,parameters,inputs,analysis_type,sub_analysis_type);
		inputs->Add("surfacearea",S);
	}

	/*Get size of matrix: */
	gsize=nodes->NumberOfDofs();

	/*Allocate du_g: */
	du_g=NewVec(gsize);

	/*Compute velocity difference: */
	elements->Du(du_g,inputs,analysis_type,sub_analysis_type);

	/*Assemble vector: */
	VecAssemblyBegin(du_g);
	VecAssemblyEnd(du_g);

	/*Assign output pointers: */
	*pdu_g=du_g;
	
}
