/*!\file CostFunctionx
 * \brief: compute misfit between observations and model
 */

#include "./CostFunctionx.h"

#undef __FUNCT__ 
#define __FUNCT__ "CostFunctionx"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../SurfaceAreax/SurfaceAreax.h"

void CostFunctionx( double* pJ, DataSet* elements,DataSet* nodes, DataSet* loads, DataSet* materials,DataSet* parameters,
			ParameterInputs* inputs,int analysis_type,int sub_analysis_type){

	/*Intermediary*/
	double fit;
	double S;

	/*output: */
	double J;
	double J_sum;
	
	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes, materials,parameters);
	parameters->Configure(elements,loads, nodes, materials,parameters);

	/*If fit=3, compute Surface Area*/
	if(!inputs->Recover("fit",&fit)) throw ErrorException(__FUNCT__," missing fit input parameter");
	if (fit==3 && !inputs->IsPresent("surfacearea")){

		SurfaceAreax(&S,elements,nodes,loads,materials,parameters,inputs,analysis_type,sub_analysis_type);
		inputs->Add("surfacearea",S);
	}

	/*Compute gradients: */
	elements->CostFunction(&J,inputs,analysis_type,sub_analysis_type);

	/*Sum all J from all cpus of the cluster:*/
	MPI_Reduce (&J,&J_sum,1,MPI_DOUBLE,MPI_SUM,0,MPI_COMM_WORLD );
	MPI_Bcast(&J_sum,1,MPI_DOUBLE,0,MPI_COMM_WORLD); 
	J=J_sum;

	/*Assign output pointers: */
	*pJ=J;
}
