function command=ClusterLaunchCommand(cluster,name,executionpath)
%CLUSTERLAUNCHCOMMAND: build command to launch job on cluster
%
%    Usage: command=ClusterLaunchCommand(cluster,executionpath)


%if cluster is current hostname, just source queue file
if strcmpi(oshostname(),cluster),
	command=['cd ' executionpath ' && source ' name '.queue '];
else
	if strcmpi(cluster,'cosmos'),
		command=['cd ' executionpath ' && rm -rf ' name '.lock ' name '.outlog ' name '.errlog ' name '.outbin && qsub -S/bin/sh ' name '.queue '];
	elseif strcmpi(cluster,'gemini'),
		command=['cd ' executionpath ' && rm -rf ' name '.lock ' name '.outlog ' name '.errlog ' name '.outbin && qsub ' name '.queue '];
	elseif strcmpi(cluster,'pollux'),
		command=['cd ' executionpath ' && rm -rf ' name '.lock ' name '.outlog ' name '.errlog ' name '.outbin && qsub ' name '.queue '];
	elseif strcmpi(cluster,'castor'),
		command=['cd ' executionpath ' && rm -rf ' name '.lock ' name '.outlog ' name '.errlog ' name '.outbin && qsub ' name '.queue '];
	elseif strcmpi(cluster,'pfe'),
		command=['cd ' executionpath ' && rm -rf ' name '.lock ' name '.outlog ' name '.errlog ' name '.outbin && qsub ' name '.queue '];
	else
		error('ClusterLaunchCommand error message: unknown cluster command');
	end
end
