function flag=waitonlock(md,executionpath,login,port)
%WAITONLOCK - wait for a file
%
%   This routine will return when a file named 'filename' is written to disk.
%   If the time limit given in input is exceeded, return 0
%
%   Usage:
%      flag=waitonlock(md,executionpath)

%Get filename (lock file) and options
filename=[executionpath '/' md.name '.lock'];
cluster=md.cluster;
timelimit=md.waitonlock;

%waitonlock will work if the lock is on the same machine only: 
if ~strcmpi(oshostname(),cluster),

	if port, 
		%there is a tunnel, so we have a short at looking for the lock file.

		disp(['waiting for ' filename ' hold on... (Ctrl+C to exit)'])
		time=0; ispresent=0;
		while (ispresent==0 & time<timelimit)
			[status, result]=system(['ssh -q -p ' num2str(port) ' ' login '@localhost "if ( -e ' executionpath '/' md.name '.lock ) echo 1"']);
			ispresent=~isempty(result);
			pause(10); %tunnel can be unstable, let's not use it too much
			time=time+1/60;
		end
		
		%build output
		if (time>timelimit),
			disp('Time limit exceeded. Increase md.waitonlock');
			disp('The results must be loaded manually with md=loadresultsfromcluster(md).');
			error(['waitonlock error message: time limit exceeded']);
			flag=0;
		else
			flag=1;
		end
	else
		disp('solution launched on remote cluster. log in to detect job completion.');
		choice=input('Is the job successfully completed? (y/n)','s');
		if ~strcmp(choice,'y'), 
			disp('Results not loaded... exiting'); 
			flag=0;
		else
			flag=1;
		end
	end

%job is running on the same machine
else

	%initialize time and file presence test flag
	time=0; ispresent=0;
	disp(['waiting for ' filename ' hold on... (Ctrl+C to exit)'])

	%loop till file .lock exist or time is up
	while (ispresent==0 & time<timelimit)
		ispresent=exist(filename,'file');
		pause(1);
		time=time+1/60;
	end

	%build output
	if (time>timelimit),
		disp('Time limit exceeded. Increase md.waitonlock');
		disp('The results must be loaded manually with md=loadresultsfromcluster(md).');
		error(['waitonlock error message: time limit exceeded']);
		flag=0;
	else
		flag=1;
	end
end
