function BuildQueueingScript(md,executionpath,codepath)
%BUILDQUEUEINGSCRIPT - Create queueing script
%
%   Usage:
%      BuildQueueingScript(md,executionpath,codepath)

disp('check queue requirements');
QueueRequirements(md.cluster,md.queue,md.np,md.time);

disp('write queueing script');

%open file 
fid=fopen([md.name '.queue'],'w');
if fid==-1,
	error(['BuildQueueingScripterror message: could not open ' [md.name '.queue'] ' file for ascii writing']);
end

%hand down to cluster specific script
ClusterScript(fid,md.cluster,md.name,md.queue,executionpath,codepath,md.analysis_type,md.np,md.time,md.mem_debug);

%close file
fclose(fid);

