#include <cstdio>
#include <cstring>
#include <cmath>
#include <ctime>

#include "../Mesh2.h"
#include "../QuadTree.h"
#include "../SetOfE4.h"

#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#undef __FUNCT__ 
#define __FUNCT__ "Triangle"

namespace bamg {

	/*Methods*/
	/*FUNCTION Triangle::FindBoundaryEdge{{{1*/
	TriangleAdjacent Triangle::FindBoundaryEdge(int i) const{

		/*Intermediary*/
		Triangle* ttc=NULL;
		int k,j,jc;

		// call current triangle t
		Triangle* t = (Triangle*)this;

		//is the current triangle inside or outside?
		int outside=!link  ;

		// EdgesVertexTriangle[3][2] = {{1,2},{2,0},{0,1}};
		// initialize j as the first vertex of the ith edge
		j=EdgesVertexTriangle[i][0];

		//Loop over the adjacent triangle of t
		k=0;
		do{
			//keep track of outside
			int outsidep = outside;
			//increment k
			k++;
			//Get ttc, adjacent triangle of t with respect to vertex j
			ttc =  t->TriaAdjTriangles[j];
			//is the current triangle inside or outside?
			outside = !ttc->link;
			//if both previous triangle are outside, return
			if (outside+outsidep == 1) return TriangleAdjacent(t,j);

			//update t and j
			t = ttc;
			//NextEdge[3] = {1,2,0};
			jc = NextEdge[t->TriaAdjSharedEdge[j]&3];
			j = NextEdge[jc];

			//check number of iterations
			if (k>=2000){
				throw ErrorException(__FUNCT__,exprintf("too many iteration in Triangle::FindBoundaryEdge (k>=2000)"));
			}
		} while (this!= t);
		//not found, return empty triangle
		return TriangleAdjacent(NULL,0);
	}
	/*}}}1*/
	/*FUNCTION Triangle::Echo {{{1*/

	void Triangle::Echo(void){

		int i;

		printf("Triangle:\n");
		printf("   TriaVertices pointer towards three vertices\n");
		printf("      TriaVertices[0] TriaVertices[1] TriaVertices[2] = %p %p %p\n",TriaVertices[0],TriaVertices[1],TriaVertices[2]);
		printf("   TriaAdjTriangles pointer towards three adjacent triangles\n");
		printf("      TriaAdjTriangles[0] TriaAdjTriangles[1] TriaAdjTriangles[2] = %p %p %p\n",TriaAdjTriangles[0],TriaAdjTriangles[1],TriaAdjTriangles[2]);
		printf("   det (integer triangle determinant) = %i\n",det);
		if (link){
			printf("   link (pointer toward duplicate triangle)= %p\n",link);
		}
		else{
			printf("   color = %i\n",color);
		}

		printf("\nThree vertices:\n");
		for(i=0;i<3;i++){
			if (TriaVertices[i]){
				TriaVertices[i]->Echo();
			}
			else{
				printf("   vertex %i does not exist\n",i+1);
			}
		}

		return;
	}
	/*}}}*/
	/*FUNCTION Triangle::Optim{{{1*/
	Int4  Triangle::Optim(Int2 i,int koption) {
		// turn around (positive direction)
		Triangle *t=this;
		Int4 NbSwap =0;
		int  k = 0;
		int  j = OppositeEdge[i];
		int  jp= PreviousEdge[j];

		// initialize tp, jp the previous triangle & edge
		Triangle *tp=TriaAdjTriangles[jp];
		jp = TriaAdjSharedEdge[jp]&3;
		do {
			while (t->swap(j,koption)){
				if (k>=20000) throw ErrorException(__FUNCT__,exprintf("k>=20000"));
				NbSwap++;
				k++;
				t=  tp->TriaAdjTriangles[jp];      // set unchange t qnd j for previous triangles
				j=  NextEdge[tp->TriaAdjSharedEdge[jp]&3];
			}
			// end on this  Triangle 
			tp = t;
			jp = NextEdge[j];

			t=  tp->TriaAdjTriangles[jp];      // set unchange t qnd j for previous triangles
			j=  NextEdge[tp->TriaAdjSharedEdge[jp]&3];

		} while( t != this);
		return NbSwap;
	}
	/*}}}1*/
	/*FUNCTION Triangle::swap{{{1*/
	int Triangle::swap(Int2 a,int koption){
		if(a/4 !=0) return 0;// arete lock or MarkUnSwap

		register Triangle *t1=this,*t2=TriaAdjTriangles[a];// les 2 triangles adjacent
		register Int1 a1=a,a2=TriaAdjSharedEdge[a];// les 2 numero de l arete dans les 2 triangles
		if(a2/4 !=0) return 0; // arete lock or MarkUnSwap

		register Vertex  *sa=t1->TriaVertices[VerticesOfTriangularEdge[a1][0]];
		register Vertex  *sb=t1->TriaVertices[VerticesOfTriangularEdge[a1][1]];
		register Vertex  *s1=t1->TriaVertices[OppositeVertex[a1]];
		register Vertex  *s2=t2->TriaVertices[OppositeVertex[a2]];

		Icoor2 det1=t1->det , det2=t2->det ;
		Icoor2 detT = det1+det2;
		Icoor2 detA = Abs(det1) + Abs(det2);
		Icoor2 detMin = Min(det1,det2);

		int OnSwap = 0;       
		// si 2 triangle infini (bord) => detT = -2;
		if (sa == 0) {// les deux triangles sont frontieres
			det2=bamg::det(s2->i,sb->i,s1->i);
			OnSwap = det2 >0;}
		else if (sb == 0) { // les deux triangles sont frontieres
			det1=bamg::det(s1->i,sa->i,s2->i);
			OnSwap = det1 >0;}
		else if(( s1 != 0) && (s2 != 0) ) {
			det1 = bamg::det(s1->i,sa->i,s2->i);
			det2 = detT - det1;
			OnSwap = (Abs(det1) + Abs(det2)) < detA;

			Icoor2 detMinNew=Min(det1,det2);
			//     if (detMin<0 && (Abs(det1) + Abs(det2) == detA)) OnSwap=BinaryRand();// just for test   
			if (! OnSwap &&(detMinNew>0)) {
				OnSwap = detMin ==0;
				if (! OnSwap) {
					int  kopt = koption;
					while (1)
					 if(kopt) {
						 // critere de Delaunay pure isotrope
						 register Icoor2 xb1 = sb->i.x - s1->i.x,
									 x21 = s2->i.x - s1->i.x,
									 yb1 = sb->i.y - s1->i.y,
									 y21 = s2->i.y - s1->i.y,
									 xba = sb->i.x - sa->i.x, 
									 x2a = s2->i.x - sa->i.x,
									 yba = sb->i.y - sa->i.y,
									 y2a = s2->i.y - sa->i.y;
						 register double
							cosb12 =  double(xb1*x21 + yb1*y21),
									 cosba2 =  double(xba*x2a + yba*y2a) ,
									 sinb12 = double(det2),
									 sinba2 = double(t2->det);


						 // angle b12 > angle ba2 => cotg(angle b12) < cotg(angle ba2)
						 OnSwap =  ((double) cosb12 * (double)  sinba2) <  ((double) cosba2 * (double) sinb12);
						 break;
					 }
					 else {	
						 // critere de Delaunay anisotrope 
						 Real8 som;
						 I2 AB=(I2) *sb - (I2) *sa;
						 I2 MAB2=((I2) *sb + (I2) *sa);
						 R2 MAB(MAB2.x*0.5,MAB2.y*0.5);
						 I2 A1=(I2) *s1 - (I2) *sa;
						 I2 D = (I2) * s1 - (I2) * sb ;
						 R2 S2(s2->i.x,s2->i.y);
						 R2 S1(s1->i.x,s1->i.y);
							{
							 Metric M=s1->m;
							 R2 ABo = M.Orthogonal(AB);
							 R2 A1o = M.Orthogonal(A1);
							 // (A+B)+ x ABo = (S1+B)/2+ y A1 
							 // ABo x - A1o y =  (S1+B)/2-(A+B)/2 = (S1-B)/2 = D/2
							 double dd = Abs(ABo.x*A1o.y)+Abs(ABo.y*A1o.x);
							 double d = (ABo.x*A1o.y - ABo.y*A1o.x)*2; // because D/2
							 if (Abs(d) > dd*1.e-3) {
								 R2 C(MAB+ABo*((D.x*A1o.y - D.y*A1o.x)/d));
								 som  = M(C - S2)/M(C - S1);
							 } else 
								{kopt=1;continue;}

							}
							{
							 Metric M=s2->m;
							 R2 ABo = M.Orthogonal(AB);
							 R2 A1o = M.Orthogonal(A1);
							 // (A+B)+ x ABo = (S1+B)/2+ y A1 
							 // ABo x - A1o y =  (S1+B)/2-(A+B)/2 = (S1-B)/2 = D/2 
							 double dd = Abs(ABo.x*A1o.y)+Abs(ABo.y*A1o.x);
							 double d = (ABo.x*A1o.y - ABo.y*A1o.x)*2; // because D/2
							 if(Abs(d) > dd*1.e-3) {
								 R2 C(MAB+ABo*((D.x*A1o.y - D.y*A1o.x)/d));
								 som  += M(C - S2)/M(C -  S1);
							 } else 
								{kopt=1;continue;}
							}
						 OnSwap = som < 2;
						 break;
						}

				} // OnSwap 
			} // (! OnSwap &&(det1 > 0) && (det2 > 0) )
		}
		if( OnSwap ) 
		 bamg::swap(t1,a1,t2,a2,s1,s2,det1,det2);
		else {
			t1->SetMarkUnSwap(a1);     
		}
		return OnSwap;
	}
	/*}}}1*/

}
