/*!\file:  pfopen.cpp
 * \brief fopen wrapper for parallel solution
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "../shared/shared.h"

#undef __FUNCT__ 
#define __FUNCT__ "pfopen"

FILE* pfopen(char* filename,char* format){

	FILE* fid=NULL;
	extern int my_rank;
	
	/*Open handle to data on disk: */
	if(my_rank==0){
		fid=fopen(filename,format);
		if(fid==NULL) throw ErrorException(__FUNCT__,exprintf("%s%s%s","could not open file ",filename," for binary reading or writing")); 
	}

	return fid;
}

