function md=solveparallel(md,options)
%SOLVEPARALLEL - solution sequence using a cluster in parallel mode
%
%   Usage:
%      md=solveparallel(md);


%Get cluster.rc location
cluster_rc_location=which('cluster.rc');

%Figure out parameters for this particular cluster
[codepath,executionpath,login]=ClusterParameters(md.cluster,cluster_rc_location);

%Append name of directory if specified in options: 
executionpath=[executionpath '/' options.directory];

%Marshall model data into a binary file.
marshall(md);

%add qmu fields to binary file if running qmu analysis
if md.qmu_analysis,
	qmumarshall(md,md.variables(options.ivar),md.responses(options.iresp));
end

%Now, we need to build the queuing script, used by the cluster to launch the job.
BuildQueueingScript(md,executionpath,codepath);

%Now, launch the queueing script
md=LaunchQueueJob(md,executionpath,options,login);

%Do we return, or just wait for results?
if (md.waitonlock~=0 &  ~strcmpi(options.batch,'yes')),
	%we wait for the done file
	islock=waitonlock(md,executionpath);
	if islock==0,
		%no results to be loaded
		disp('The results must be loaded manually with md=loadresultsfromcluster(md).');
	else
		%load results
		displaystring(md.verbose,'loading results from cluster');
		md=loadresultsfromcluster(md);
	end
end
