function md=LaunchQueueJobgreenplanet(md,executionpath,options,login)
%LAUNCHQUEUEJOBGEMINI - ...
%
%   Usage:
%      LaunchQueueJobgreenplanet(md,executionpath)

%first, check we have the binary file and the queueing script
if ~exist([ md.name '.bin'],'file'),
	error('LaunchQueueJobgreenplanet error message: Binary input file missing, cannot go forward');
end

if ~exist([ md.name '.queue'],'file'),
	error('LaunchQueueJobgreenplanet error message: queueing script issing, cannot go forward');
end

%jpload both files to cluster
if ~strcmpi(options.batch,'yes'),
	disp('uploading input file,  queueing script and variables script');
	if md.qmu_analysis, 
		system(['scp -P 1025 -o HostKeyAlias=huey.jpl.nasa.gov ' md.name '.bin' ' ' md.name '.queue '  md.name '.qmu.in elarour@localhost:' executionpath]);
	else
		system(['scp -P 1025 -o HostKeyAlias=huey.jpl.nasa.gov ' md.name '.bin' ' ' md.name '.queue elarour@localhost:' executionpath ]);
	end
else
	disp('batch mode requested: not launching job interactively');
end

%new greenplanet cannot launch across cluster using ssh
disp(['launch solution sequence on remote cluster by logging into it and typing qsub < ' md.name '.queue']);
