/*! \file CreateLoadsDiagnosticStokes.c:
 */

#undef __FUNCT__ 
#define __FUNCT__ "CreateLoadsDiagnosticStokes"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../IoModel.h"


void	CreateLoadsDiagnosticStokes(DataSet** ploads, IoModel* iomodel,ConstDataHandle iomodel_handle){

	int i,j,counter;
	int element;

	extern int my_rank;
	extern int num_procs;
	
	DataSet*    loads    = NULL;
	Icefront*   icefront = NULL;
	Pengrid*    pengrid  = NULL;

	int segment_width;
	int i1,i2,i3,i4;
	int i0,range;
	int grid1,grid2;

	/*icefront intermediary data: */
	char icefront_type[ICEFRONTSTRING];
	int  icefront_fill;
	int  icefront_element_type;
	int  icefront_sid;
	int icefront_eid;
	int icefront_mparid;
	int	icefront_node_ids[MAX_ICEFRONT_GRIDS];
	double icefront_h[MAX_ICEFRONT_GRIDS];
	double	icefront_b[MAX_ICEFRONT_GRIDS];

	/*pengrid intermediary data: */
	int pengrid_id;
	int pengrid_mparid;
	int pengrid_node_id;
	int pengrid_dof;
	double pengrid_penalty_offset;
	int pengrid_active=0;
	int pengrid_thermal_steadystate=1;
	int pengrid_stabilize_constraints=0;

	int numberofpressureloads;
	int count;


	/*Create loads: */
	loads   = new DataSet(LoadsEnum());

	/*Now, is the flag ishutter on? otherwise, do nothing: */
	if (!iomodel->isstokes)goto cleanup_and_return;

	/*Create pressure loads as boundary conditions. Pay attention to the partitioning if we are running in parallel (the grids
	 * referenced by a certain load must belong to the cluster node): */
	IoModelFetchData(&iomodel->pressureload,&numberofpressureloads,NULL,iomodel_handle,"pressureload");
	IoModelFetchData(&iomodel->elements_type,NULL,NULL,iomodel_handle,"elements_type");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");

	count=0;

	/*First load data:*/
	for (i=0;i<numberofpressureloads;i++){
		
		segment_width=6;

		element=(int)(*(iomodel->pressureload+segment_width*i+segment_width-2)-1); //element is in the penultimate column (grid1 grid2 ... elem fill)

		#ifdef _PARALLEL_
		if (iomodel->epart[element]!=my_rank){
			/*This load does not belong to this cluster node, as it references an element 
			 *that does not belong to this node's partition. Drop this 'i':*/
			continue;
		}
		#endif
	
		/*Do not create ice front if it is not a Stokes element*/
		if (!(int)*(iomodel->elements_type+2*element+1)==StokesFormulationEnum()){ 
			continue;
		}

		icefront_mparid=iomodel->numberofelements+1; //matlab indexing
		icefront_sid=count+1; //matlab indexing
		icefront_fill=(int)*(iomodel->pressureload+segment_width*i+segment_width-1);
		icefront_eid=(int) *(iomodel->pressureload+segment_width*i+segment_width-2); //matlab indexing
		icefront_element_type=PentaEnum();

		i1=(int)*(iomodel->pressureload+segment_width*i+0);
		i2=(int)*(iomodel->pressureload+segment_width*i+1);
		i3=(int)*(iomodel->pressureload+segment_width*i+2);
		i4=(int)*(iomodel->pressureload+segment_width*i+3);
	
		icefront_node_ids[0]=i1;
		icefront_node_ids[1]=i2;
		icefront_node_ids[2]=i3;
		icefront_node_ids[3]=i4;
	
		icefront_h[0]=iomodel->thickness[i1-1];
		icefront_h[1]=iomodel->thickness[i2-1];
		icefront_h[2]=iomodel->thickness[i3-1];
		icefront_h[3]=iomodel->thickness[i4-1];

		icefront_b[0]=iomodel->bed[i1-1];
		icefront_b[1]=iomodel->bed[i2-1];
		icefront_b[2]=iomodel->bed[i3-1];
		icefront_b[3]=iomodel->bed[i4-1];
	
		icefront = new Icefront(icefront_type,icefront_fill,icefront_sid,icefront_mparid,icefront_eid,icefront_element_type,icefront_node_ids,icefront_h,icefront_b);
		
		loads->AddObject(icefront);
		count++;

	}
	/*Free data: */
	xfree((void**)&iomodel->pressureload);
	xfree((void**)&iomodel->elements_type);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->bed);

	//create penalties for grids on the base of icesheet. We must have wb=ub*db/dx+vb*db/dy

	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");
	IoModelFetchData(&iomodel->gridonicesheet,NULL,NULL,iomodel_handle,"gridonicesheet");
	IoModelFetchData(&iomodel->gridonstokes,NULL,NULL,iomodel_handle,"gridonstokes");
	
	for (i=0;i<iomodel->numberofnodes;i++){
	#ifdef _PARALLEL_
	/*keep only this partition's nodes:*/
	if((iomodel->my_grids[i]==1)){
	#endif

		if ((iomodel->gridonbed[i]) && (iomodel->gridonicesheet[i]) && (iomodel->gridonstokes[i])){

			pengrid_id=count+1; //matlab indexing
			pengrid_node_id=i+1;
			pengrid_dof=1;
			pengrid_penalty_offset=iomodel->penalty_offset;
			pengrid_mparid=iomodel->numberofelements+1;//refers to the corresponding parmat property card
			pengrid_stabilize_constraints=iomodel->stabilize_constraints;
			pengrid= new Pengrid(pengrid_id, pengrid_node_id,pengrid_mparid,pengrid_dof, pengrid_active, pengrid_penalty_offset,pengrid_thermal_steadystate,pengrid_stabilize_constraints);
			
			loads->AddObject(pengrid);
			count++;
		}
	#ifdef _PARALLEL_
	} //if((iomodel->my_grids[i]==1))
	#endif
	}

	xfree((void**)&iomodel->gridonbed);
	xfree((void**)&iomodel->gridonstokes);
	xfree((void**)&iomodel->gridonicesheet);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	loads->Presort();

	cleanup_and_return:

	/*Assign output pointer: */
	*ploads=loads;

}
