/*! \file CreateLoadsDiagnosticHoriz.c:
 */

#undef __FUNCT__ 
#define __FUNCT__ "CreateLoadsDiagnosticHoriz"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../IoModel.h"


void	CreateLoadsDiagnosticHoriz(DataSet** ploads, IoModel* iomodel,ConstDataHandle iomodel_handle){

	int i;
	int element;

	extern int my_rank;
	extern int num_procs;
	
	DataSet*    loads    = NULL;
	Icefront*   icefront = NULL;
	Riftfront*  riftfront= NULL;

	int segment_width;
	int element_type;
	int i1,i2,i3,i4;
	int i0,range;

		
	/*icefront intermediary data: */
	char icefront_type[ICEFRONTSTRING];
	int  icefront_fill;
	int  icefront_element_type;
	int  icefront_sid;
	int  icefront_eid;
	int  icefront_mparid;
	int  icefront_node_ids[MAX_ICEFRONT_GRIDS];
	double icefront_h[MAX_ICEFRONT_GRIDS];
	double	icefront_b[MAX_ICEFRONT_GRIDS];

	/*rifts: */
	char riftfront_type[RIFTFRONTSTRING];
	int  riftfront_id;
	int  riftfront_node_ids[2];
	int  riftfront_mparid;
	double riftfront_h[2];
	double riftfront_b[2];
	double riftfront_s[2];
	double riftfront_normal[2];
	double riftfront_length;
	int    riftfront_fill;
	double riftfront_friction;
	double riftfront_fraction;
	double riftfront_fractionincrement;
	bool   riftfront_shelf;
	double riftfront_penalty_offset;
	int riftfront_penalty_lock;
	bool riftfront_active;
	int  riftfront_counter;
	bool riftfront_prestable;
	int el1,el2;
	int grid1,grid2;
	double normal[2];
	double length;
	int    fill;
	double friction;
	double fraction;
	double fractionincrement;
	
	/*Create loads: */
	loads   = new DataSet(LoadsEnum());

	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if (!iomodel->ismacayealpattyn)goto cleanup_and_return;
	
	/*Create pressure loads as boundary conditions. Pay attention to the partitioning if we are running in parallel (the grids
	 * referenced by a certain load must belong to the cluster node): */
	IoModelFetchData(&iomodel->pressureload,&iomodel->numberofpressureloads,NULL,iomodel_handle,"pressureload");
	IoModelFetchData(&iomodel->elements_type,NULL,NULL,iomodel_handle,"elements_type");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");

	/*First load data:*/
	for (i=0;i<iomodel->numberofpressureloads;i++){
		
		if (strcmp(iomodel->meshtype,"2d")==0){
			segment_width=4;
			element_type=TriaEnum();
		}
		else{
			segment_width=6;
			element_type=PentaEnum();
		}


		element=(int)(*(iomodel->pressureload+segment_width*i+segment_width-2)-1); //element is in the penultimate column (grid1 grid2 ... elem fill)

		#ifdef _PARALLEL_
		if (iomodel->epart[element]!=my_rank){
			/*This load does not belong to this cluster node, as it references an element 
			 *that does not belong to this node's partition. Drop this 'i':*/
			continue;
		}

		#endif
	
		/*Do not create ice front if Hutter or Stokes elements*/
		if ((int)*(iomodel->elements_type+2*element+0)==(HutterFormulationEnum() || StokesFormulationEnum())){ 
			continue;
		}

		icefront_mparid=iomodel->numberofelements+1; //matlab indexing
		icefront_sid=i+1; //matlab indexing
		icefront_fill=(int)*(iomodel->pressureload+segment_width*i+segment_width-1); 
		icefront_eid=(int) *(iomodel->pressureload+segment_width*i+segment_width-2); //matlab indexing
		icefront_element_type=element_type;

		i1=(int)*(iomodel->pressureload+segment_width*i+0);
		i2=(int)*(iomodel->pressureload+segment_width*i+1);
			
		icefront_node_ids[0]=i1;
		icefront_node_ids[1]=i2;
		
		icefront_h[0]=iomodel->thickness[i1-1];
		icefront_h[1]=iomodel->thickness[i2-1];

		icefront_b[0]=iomodel->bed[i1-1];
		icefront_b[1]=iomodel->bed[i2-1];
		
		if ((int)*(iomodel->elements_type+2*element+0)==MacAyealFormulationEnum()){ //this is a collapsed 3d element, icefront will be 2d
			strcpy(icefront_type,"segment");
		}
		else if ((int)*(iomodel->elements_type+2*element+0)==PattynFormulationEnum()){ //this is a real 3d element, icefront will be 3d.
			strcpy(icefront_type,"quad");
			i3=(int)*(iomodel->pressureload+segment_width*i+2);
			i4=(int)*(iomodel->pressureload+segment_width*i+3);
			icefront_node_ids[2]=i3;
			icefront_node_ids[3]=i4;
			
			icefront_h[2]=iomodel->thickness[i3-1];
			icefront_h[3]=iomodel->thickness[i4-1];

			icefront_b[2]=iomodel->bed[i3-1];
			icefront_b[3]=iomodel->bed[i4-1];
		}
		else{
			throw ErrorException(__FUNCT__,exprintf(" element type %i not supported yet",(int)*(iomodel->elements_type+2*element+0)));
		}

		icefront = new Icefront(icefront_type,icefront_fill,icefront_sid,icefront_mparid,icefront_eid,icefront_element_type,icefront_node_ids,icefront_h,icefront_b);
		
		loads->AddObject(icefront);

	}
	/*Free data: */
	xfree((void**)&iomodel->pressureload);
	xfree((void**)&iomodel->elements_type);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->bed);

	/*Create penpair loads also for rift grids, so that they don't penetrate one another, if needed: */
	/*First fetch rifts: */
	IoModelFetchData(&iomodel->riftinfo,&iomodel->numrifts,NULL,iomodel_handle,"riftinfo");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
	IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,"surface");
	IoModelFetchData(&iomodel->gridoniceshelf,NULL,NULL,iomodel_handle,"gridoniceshelf");
	
	if(iomodel->numrifts){
		for(i=0;i<iomodel->numrifts;i++){
				
			el1=(int)*(iomodel->riftinfo+RIFTINFOSIZE*i+2);
			#ifdef _PARALLEL_
			if (iomodel->epart[el1-1]!=my_rank){
				/*This load does not belong to this cluster node, as it references an element 
				 *that does not belong to this node's partition. Drop this 'j':*/
				continue;
			}
			#endif

			/*Ok, retrieve all the data needed to add a penalty between the two grids: */
			el2=(int)*(iomodel->riftinfo+RIFTINFOSIZE*i+3); 

			grid1=(int)*(iomodel->riftinfo+RIFTINFOSIZE*i+0); 
			grid2=(int)*(iomodel->riftinfo+RIFTINFOSIZE*i+1);
			
			normal[0]=*(iomodel->riftinfo+RIFTINFOSIZE*i+4);
			normal[1]=*(iomodel->riftinfo+RIFTINFOSIZE*i+5);
			length=*(iomodel->riftinfo+RIFTINFOSIZE*i+6);
			
			fill = (int)*(iomodel->riftinfo+RIFTINFOSIZE*i+7);
			friction=*(iomodel->riftinfo+RIFTINFOSIZE*i+8);
			fraction=*(iomodel->riftinfo+RIFTINFOSIZE*i+9);
			fractionincrement=*(iomodel->riftinfo+RIFTINFOSIZE*i+10);
	
			strcpy(riftfront_type,"2d");
			riftfront_id=i+1; //matlab indexing
			riftfront_node_ids[0]=grid1;
			riftfront_node_ids[1]=grid2;
			riftfront_mparid=iomodel->numberofelements+1; //matlab indexing

			riftfront_h[0]=iomodel->thickness[grid1-1];
			riftfront_h[1]=iomodel->thickness[grid2-1];

			riftfront_b[0]=iomodel->bed[grid1-1];
			riftfront_b[1]=iomodel->bed[grid2-1];

			riftfront_s[0]=iomodel->surface[grid1-1];
			riftfront_s[1]=iomodel->surface[grid2-1];

			riftfront_normal[0]=normal[0];
			riftfront_normal[1]=normal[1];
			riftfront_length=length;
			
			riftfront_fill=fill;
			riftfront_friction=friction;
			riftfront_fraction=fraction;
			riftfront_fractionincrement=fractionincrement;
			riftfront_shelf=(bool)iomodel->gridoniceshelf[grid1-1];

			riftfront_penalty_offset=iomodel->penalty_offset;
			riftfront_penalty_lock=iomodel->penalty_lock;

			riftfront_active=0;
			riftfront_counter=0;
			riftfront_prestable=0;
			
			riftfront=new Riftfront(riftfront_type,riftfront_id, riftfront_node_ids, riftfront_mparid, riftfront_h,riftfront_b,riftfront_s,riftfront_normal,riftfront_length,riftfront_fill,riftfront_friction, riftfront_fraction, riftfront_fractionincrement, riftfront_penalty_offset, riftfront_penalty_lock, riftfront_active,riftfront_counter,riftfront_prestable,riftfront_shelf);

			loads->AddObject(riftfront);
		}
	}


	/*free ressources: */
	xfree((void**)&iomodel->riftinfo);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->surface);
	xfree((void**)&iomodel->gridoniceshelf);


	cleanup_and_return:

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	loads->Presort();

	/*Assign output pointer: */
	*ploads=loads;

}
