function md=geography2(md,landname,iceshelfname,icesheetname)
%GEOGRAPHY2 - establish land, ice sheet and ice shelf areas in a domains.
%
%   Usage:
%      md=geography2(md,landname,iceshelfname,icesheetname)
%
%   Examples:
%      md=geography2(md,'LandName.exp','Iceshelves.exp','Islands.exp');

%Get assigned fields
x=md.x;
y=md.y;
elements=md.elements;

%recover elements and grids on land.
if ischar(landname),
	[gridonland,elementonland]=ContourToMesh(elements,x,y,expread(landname,1),'element and node',2);
elseif isfloat(landname),
	if size(landname,1)~=md.numberofelements,
		error('Landname for area must be of same size as number of elements in model');
	end
	elementonland=landname;
	gridonland=zeros(md.numberofgrids,1);
	gridonland(md.elements(find(elementonland),:))=1;
else
	error('Invalid area option option');
end

%any element with 3 grids on land should be on land:
elementsonwater=find(~elementonland);
wrongelements=elementsonwater(find(( gridonland(md.elements(elementsonwater,1)) + gridonland(md.elements(elementsonwater,2)) + gridonland(md.elements(elementsonwater,3)) ...
                  )==3));
elementonland(wrongelements)=1;

%any element with its barycentre on land should be on land:
weights={[1;1;1],[2;1;1],[1;2;1],[1;1;2]};
for i=1:length(weights),
	xelem=x(md.elements)*weights{i}/sum(weights{i});
	yelem=y(md.elements)*weights{i}/sum(weights{i});
end
baryonland=ContourToNodes(xelem,yelem,expread(landname,1),1);
pos=find(~baryonland); elementonland(pos)=0;
pos=find(baryonland); elementonland(pos)=1;

%figure out which elements on land are actually in the middle of the ocean!
pos1=find(elementonland); 
connectedtoland=md.elementconnectivity(pos1,:);
pos=find(connectedtoland); connectedtoland(pos)=1-elementonland(connectedtoland(pos));
connectedtolandsum=sum(connectedtoland,2);
waterelements=pos1(find(connectedtolandsum==3));
elementonland(waterelements)=0;

%figure out which elements on water  are actually in the middle of the land!
pos1=find(~elementonland); 
connectedtowater=md.elementconnectivity(pos1,:);
pos=find(connectedtowater); connectedtowater(pos)=elementonland(connectedtowater(pos));
connectedtowatersum=sum(connectedtowater,2);
landelements=pos1(find(connectedtowatersum==3));
elementonland(landelements)=1;

%recover arrays of ice shelf grids and elements, and ice sheet grids and elements.
elementoniceshelf=FlagElements(md,iceshelfname);
elementonicesheet=FlagElements(md,icesheetname);

%Because icesheet grids and elements can be included into an iceshelf, we need to update. Remember, all the previous 
%arrays come from domain outlines that can intersect one another: 
gridoniceshelf=zeros(md.numberofgrids,1);
gridonicesheet=zeros(md.numberofgrids,1);
elementoniceshelf=double((elementoniceshelf & ~elementonicesheet));
elementonicesheet=double(~elementoniceshelf);
gridoniceshelf(md.elements(find(elementoniceshelf),:))=1;
gridonicesheet(md.elements(find(elementonicesheet),:))=1;

%now correct, so that none of the iceshelf and icesheet elements and nodes are in the water.
pos=find(~elementonland);
elementoniceshelf(pos)=0; 
elementonicesheet(pos)=0;

pos=find(~gridonland);
gridoniceshelf(pos)=0; 
gridonicesheet(pos)=0;

%create gridonwater and elementonwater: 
gridonwater=double(~gridonland);
elementonwater=double(~elementonland);


%correct for islands:
gridoniceshelf=double(gridoniceshelf & ~gridonicesheet);
elementoniceshelf=double(elementoniceshelf & ~elementonicesheet);

%now, icesheets are everything except iceshelves and water
gridonicesheet=double(~gridoniceshelf & ~gridonwater);
elementonicesheet=double(~elementoniceshelf & ~elementonwater);



%Deal with segments on neumann: 
elementconnectivity=md.elementconnectivity;
pos=find(elementconnectivity);
elementconnectivity(pos)=elementonwater(elementconnectivity(pos));

pos=find(elementonwater);
elementconnectivity(pos,:)=0;

num_segments=sum(sum(elementconnectivity));
segments=zeros(num_segments,3);

icefrontelementsonland=find(sum(elementconnectivity,2));

count=1;
for i=1:numel(icefrontelementsonland),
	el1=icefrontelementsonland(i);
	els2=md.elementconnectivity(el1,find(elementconnectivity(el1,:)));
	for j=1:numel(els2),
		el2=els2(j);
		%we have a segment between land el1 and water el2:
		segments(count,:)=[intersect(md.elements(el1,:),md.elements(el2,:)) el1];
		
		ord1=find(segments(count,1)==md.elements(el1,:));
		ord2=find(segments(count,2)==md.elements(el1,:));

		%swap segment grids if necessary
		if ( (ord1==1 & ord2==2) | (ord1==2 & ord2==3) | (ord1==3 & ord2==1) ),
			temp=segments(count,1);
			segments(count,1)=segments(count,2);
			segments(count,2)=temp;
		end
		segments(count,1:2)=fliplr(segments(count,1:2));
		
		count=count+1;
	end
end


%some final checks: 
%check that no grid thinks it's on an ice shelf or ice sheet, and lies actually in the middle of the water.
gridsgrounded=find(~gridonwater);
lengthconnectivity=size(md.nodeconnectivity,2);
groundedcounters=md.nodeconnectivity(gridsgrounded,lengthconnectivity);
groundedconnectivity=md.nodeconnectivity(gridsgrounded,1:lengthconnectivity-1);
pos=find(groundedconnectivity);
groundedconnectivity(pos)=elementonwater(groundedconnectivity(pos));
groundedsum=sum(groundedconnectivity,2);
errorflags=find(groundedsum==groundedcounters);
errorgrids=gridsgrounded(errorflags);

gridonwater(errorgrids)=1;
gridonicesheet(errorgrids)=0;
gridoniceshelf(errorgrids)=0;

%Return: 
md.gridoniceshelf=gridoniceshelf;
md.elementoniceshelf=elementoniceshelf;

md.gridonwater=gridonwater;
md.elementonwater=elementonwater;

md.gridonicesheet=gridonicesheet;
md.elementonicesheet=elementonicesheet;

md.counter=2;
md.segmentmarkers(:)=1;
