/*
 * CreateConstraintsDiagnosticHutter.c:
 */

#undef __FUNCT__ 
#define __FUNCT__ "CreateConstraintsDiagnosticHutter"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../Model.h"


void	CreateConstraintsDiagnosticHutter(DataSet** pconstraints, Model* model,ConstDataHandle model_handle){

	int i;
	int count;

	DataSet* constraints = NULL;

	Spc*    spc  = NULL;

	/*spc intermediary data: */
	int spc_sid;
	int spc_node;
	int spc_dof;
	double spc_value;
	
	/*Create constraints: */
	constraints = new DataSet(ConstraintsEnum());

	/*Now, is the flag ishutter on? otherwise, do nothing: */
	if (!model->ishutter)goto cleanup_and_return;

	count=0;
	
	/*Fetch data: */
	ModelFetchData((void**)&model->gridonhutter,NULL,NULL,model_handle,"gridonhutter","Matrix","Mat");

	/*vx and vy are spc'd if we are not on gridonhutter: */
	for (i=0;i<model->numberofnodes;i++){
	#ifdef _PARALLEL_
	/*keep only this partition's nodes:*/
	if((model->npart[i]==1)){
	#endif

		if ((int)model->gridonhutter[i]){
	
			spc_sid=count;
			spc_node=i+1;
			spc_dof=1; //we enforce first x translation degree of freedom
			spc_value=0;

			spc = new Spc(spc_sid,spc_node,spc_dof,spc_value);
			constraints->AddObject(spc);
			count++;

			spc_sid=count;
			spc_node=i+1;
			spc_dof=2; //we enforce first y translation degree of freedom
			spc_value=0;
			
			spc = new Spc(spc_sid,spc_node,spc_dof,spc_value);
			constraints->AddObject(spc);
			count++;
		}

	#ifdef _PARALLEL_
	} //if((npart[i]==1))
	#endif
	}

	/*Free data: */
	xfree((void**)&model->gridonhutter);

	//deal with mpcs for 2d-3d mesh transitions
	
	/*Fetch data: */
	ModelFetchData((void**)&model->penalties,&model->numpenalties,NULL,model_handle,"penalties","Matrix","Mat");

	if (strcmp(model->meshtype,"3d")==0){
	
		if (model->numpenalties){
			for (i=0;i<model->numpenalties;i++){
				for (j=0;j<model->numlayers-1;j++){

					//constrain first dof
					rgb_id=count;
					rgb_dof=1;
					rgb_nodeid1=*(model->penalties+(model->numlayers-1)*i+j);
					rgb_nodeid1=*(model->penalties+(model->numlayers-1)*i+j+1);
					
					rgb = new Rgb(rgb_id,rgb_nodeid1,rgb_nodeid2,rgb_dof);
					constraints->AddObject(rgb);
					count++;

					//constrain second dof
					rgb_id=count;
					rgb_dof=2;
					rgb_nodeid1=*(model->penalties+(model->numlayers-1)*i+j);
					rgb_nodeid1=*(model->penalties+(model->numlayers-1)*i+j+1);
					
					rgb = new Rgb(rgb_id,rgb_nodeid1,rgb_nodeid2,rgb_dof);
					constraints->AddObject(rgb);
					count++;
	
				}
			}
		}
	}

	/*Free data: */
	xfree((void**)&model->penalties);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	constraints->Presort();

	cleanup_and_return:
	
	/*Assign output pointer: */
	*pconstraints=constraints;
}
