function md=slopecompute(md);
%SLOPECOMPUTE - compute the slope of a model
%
%   Usage:
%      md=slopecompute(md)
%
	%timing
	t1=clock;

	%Build all models requested for diagnostic simulation
	models.analysis_type=SlopeComputeAnalysisEnum; %needed for processresults

	displaystring(md.verbose,'\n%s',['reading surface and bed slope computation model data']);
	md.analysis_type=SlopeComputeAnalysisEnum; md.sub_analysis_type=NoneAnalysisEnum; models.sl=CreateFemModel(md);
	
	% figure out number of dof: just for information purposes.
	md.dof=modelsize(models);

	%initialize inputs
	inputs=inputlist;

	%compute solution
	displaystring(md.verbose,'\n%s',['call computational core:']);
	slopex=diagnostic_core_linear(models.sl,inputs,SlopeComputeAnalysisEnum(),SurfaceXAnalysisEnum());
	slopey=diagnostic_core_linear(models.sl,inputs,SlopeComputeAnalysisEnum(),SurfaceYAnalysisEnum());

	results.slopex=slopex;
	results.slopey=slopey;
	results.step=1;
	results.time=0;
	
	displaystring(md.verbose,'\n%s',['load results...']);
	if ~isstruct(md.results), md.results=struct(); end
	md.results.slope=processresults(models,results);

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);
