function md=loadresults(md,u_g,p_g,m_dh,m_ds,m_dhu);
%LOADRESULTS - load results onto model
%
%   The solution (vel,pressure,...) are on the g-set,
%   use index to get the value on each node
%
%   Usage:
%      md=Loadresults(md,u_g,p_g,m_dh,m_ds,m_dhu)

debug=m_dhu.parameters.debug;
dim=m_dhu.parameters.dim;
ishutter=m_dhu.parameters.ishutter;
ismacayealpattyn=m_dh.parameters.ismacayealpattyn;
isstokes=m_ds.parameters.isstokes;

if dim==2,
	
	md.vx=u_g(1:2:end)*md.yts;
	md.vy=u_g(2:2:end)*md.yts;
	md.vel=sqrt(md.vx.^2+md.vy.^2);
	md.pressure=p_g;

else

	if ismacayealpattyn | ishutter,
	
		md.vx=u_g(1:3:end)*md.yts;
		md.vy=u_g(2:3:end)*md.yts;
		md.vz=u_g(3:3:end)*md.yts;
		md.pressure=p_g;
	else
		md.vx=u_g(1:4:end)*md.yts;
		md.vy=u_g(2:4:end)*md.yts;
		md.vz=u_g(3:4:end)*md.yts;
		md.pressure=u_g(4:4:end)
	end
	md.vel=sqrt(md.vx.^2+md.vy.^2+md.vz.^2);
end
