/* \file FetchNodeSets.c:
 * \brief: interface for reading nodesets from matlab workspace
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#undef __FUNCT__ 
#define __FUNCT__  "FetchNodeSets"

#ifdef _SERIAL_
#include <mex.h>

#include "../objects/NodeSets.h"
#include "./io.h"

void  FetchNodeSets(NodeSets** pnodesets,ConstDataHandle dataref){

	/*output: */
	NodeSets* nodesets=NULL;
	double* pv_m=NULL;
	double* pv_n=NULL;
	double* pv_f=NULL;
	double* pv_s=NULL;
	int gsize;
	int msize;
	int nsize;
	int fsize;
	int ssize;

	if(mxIsEmpty(dataref)){
		nodesets=NULL;
	}
	else{

		FetchData((void**)&pv_m,NULL,NULL,mxGetField(dataref,0,"pv_m"),"Vector","Vec");
		FetchData((void**)&pv_n,NULL,NULL,mxGetField(dataref,0,"pv_n"),"Vector","Vec");
		FetchData((void**)&pv_f,NULL,NULL,mxGetField(dataref,0,"pv_f"),"Vector","Vec");
		FetchData((void**)&pv_s,NULL,NULL,mxGetField(dataref,0,"pv_s"),"Vector","Vec");
		
		gsize=(int)mxGetScalar(mxGetField(dataref,0,"gsize"));
		msize=(int)mxGetScalar(mxGetField(dataref,0,"msize"));
		nsize=(int)mxGetScalar(mxGetField(dataref,0,"nsize"));
		fsize=(int)mxGetScalar(mxGetField(dataref,0,"fsize"));
		ssize=(int)mxGetScalar(mxGetField(dataref,0,"ssize"));

		nodesets=new NodeSets( pv_m,pv_n,pv_f,pv_s,gsize,msize,nsize,fsize,ssize);
	}

	/*Assign output pointers:*/
	*pnodesets=nodesets;

}
#endif
