/* \file AnalysisTypeAsEnum.cpp
 * \brief get integer enum instead of a string
 */

#include "./EnumDefinitions.h"
#include "../shared/shared.h"

#undef __FUNCT__ 
#define __FUNCT__ "AnalysisTypeAsEnum"

int AnalysisTypeAsEnum(char* analysis_type){

	if (analysis_type==NULL){
		throw ErrorException(__FUNCT__," analysis_type is NULL");
	}

	if (strcmp(analysis_type,"control")==0){
		return ControlAnalysisEnum();
	}
	else if (strcmp(analysis_type,"diagnostic_horiz")==0){
		return DiagnosticHorizAnalysisEnum();
	}
	else if (strcmp(analysis_type,"diagnostic_vert")==0){
		return DiagnosticVertAnalysisEnum();
	}
	else if (strcmp(analysis_type,"prognostic")==0){
		return PrognosticAnalysisEnum();
	}
	else if (strcmp(analysis_type,"thermalsteady")==0){
		return ThermalSteadyAnalysisEnum();
	}
	else if (strcmp(analysis_type,"thermaltransient")==0){
		return ThermalTransientAnalysisEnum();
	}
	else if (strcmp(analysis_type,"melting")==0){
		return MeltingAnalysisEnum();
	}
	else if (strcmp(analysis_type,"diagnostic_stokes")==0){
		return DiagnosticStokesAnalysisEnum();
	}
	else if (strcmp(analysis_type,"diagnostic_hutter")==0){
		return DiagnosticHutterAnalysisEnum();
	}
	else if (strcmp(analysis_type,"surface_slope_compute")==0){
		return SurfaceSlopeComputeAnalysisEnum();
	}
	else if (strcmp(analysis_type,"bed_slope_compute")==0){
		return BedSlopeComputeAnalysisEnum();
	}
	else throw ErrorException(__FUNCT__," could not recognized analysis type!");

}


