/*!\file Sing.c
 * \brief: implementation of the Sing object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "./Sing.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../DataSet/DataSet.h"
#include "../include/typedefs.h"


/*Object constructors and destructor*/
/*FUNCTION Sing::constructor {{{1*/
Sing::Sing(){
	return;
}
/*}}}*/
/*FUNCTION Sing::destructor {{{1*/
Sing::~Sing(){
	return;
}
/*}}}*/
/*FUNCTION Sing::creation {{{1*/
Sing::Sing(int sing_id, int sing_mid, int sing_mparid, int sing_numparid,int sing_g, double sing_h, double sing_k){

	id=sing_id;
	mid=sing_mid;
	mparid=sing_mparid;
	numparid=sing_numparid;

	node_id=sing_g;
	node_offset=UNDEF;
	node=NULL;

	numpar=NULL;
	numpar_offset=UNDEF;
	
	h=sing_h;
	k=sing_k;
	
	matice=NULL;
	matice_offset=UNDEF;
	matpar=NULL;
	matpar_offset=UNDEF;

	numpar=NULL;
	numpar_offset=UNDEF;

	return;
}
/*}}}*/

/*Object marshall*/
/*FUNCTION Sing::Marshall {{{1*/
void  Sing::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of Sing: */
	enum_type=SingEnum();
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*marshall Sing data: */
	memcpy(marshalled_dataset,&id,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(marshalled_dataset,&mid,sizeof(mid));marshalled_dataset+=sizeof(mid);
	memcpy(marshalled_dataset,&mparid,sizeof(mparid));marshalled_dataset+=sizeof(mparid);
	memcpy(marshalled_dataset,&node_id,sizeof(node_id));marshalled_dataset+=sizeof(node_id);
	memcpy(marshalled_dataset,&node,sizeof(node));marshalled_dataset+=sizeof(node);
	memcpy(marshalled_dataset,&node_offset,sizeof(node_offset));marshalled_dataset+=sizeof(node_offset);
	memcpy(marshalled_dataset,&matice,sizeof(matice));marshalled_dataset+=sizeof(matice);
	memcpy(marshalled_dataset,&matice_offset,sizeof(matice_offset));marshalled_dataset+=sizeof(matice_offset);
	memcpy(marshalled_dataset,&matpar,sizeof(matpar));marshalled_dataset+=sizeof(matpar);
	memcpy(marshalled_dataset,&matpar_offset,sizeof(matpar_offset));marshalled_dataset+=sizeof(matpar_offset);
	memcpy(marshalled_dataset,&numparid,sizeof(numparid));marshalled_dataset+=sizeof(numparid);
	memcpy(marshalled_dataset,&numpar,sizeof(numpar));marshalled_dataset+=sizeof(numpar);
	memcpy(marshalled_dataset,&numpar_offset,sizeof(numpar_offset));marshalled_dataset+=sizeof(numpar_offset);
	memcpy(marshalled_dataset,&h,sizeof(h));marshalled_dataset+=sizeof(h);
	memcpy(marshalled_dataset,&k,sizeof(k));marshalled_dataset+=sizeof(k);
	
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION Sing::MashallSize {{{1*/
int   Sing::MarshallSize(){
	return sizeof(id)
		+sizeof(mid)
		+sizeof(mparid)
		+sizeof(node_id)
		+sizeof(node)
		+sizeof(node_offset)
		+sizeof(matice)
		+sizeof(matice_offset)
		+sizeof(matpar)
		+sizeof(matpar_offset)
		+sizeof(numparid)
		+sizeof(numpar)
		+sizeof(numpar_offset)
		+sizeof(h)
		+sizeof(k)
		+sizeof(int); //sizeof(int) for enum type
}
/*}}}*/
/*FUNCTION Sing::Demarshall {{{1*/
void  Sing::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/

	memcpy(&id,marshalled_dataset,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(&mid,marshalled_dataset,sizeof(mid));marshalled_dataset+=sizeof(mid);
	memcpy(&mparid,marshalled_dataset,sizeof(mparid));marshalled_dataset+=sizeof(mparid);
	memcpy(&node_id,marshalled_dataset,sizeof(node_id));marshalled_dataset+=sizeof(node_id);
	memcpy(&node,marshalled_dataset,sizeof(node));marshalled_dataset+=sizeof(node);
	memcpy(&node_offset,marshalled_dataset,sizeof(node_offset));marshalled_dataset+=sizeof(node_offset);
	memcpy(&matice,marshalled_dataset,sizeof(matice));marshalled_dataset+=sizeof(matice);
	memcpy(&matice_offset,marshalled_dataset,sizeof(matice_offset));marshalled_dataset+=sizeof(matice_offset);
	memcpy(&matpar,marshalled_dataset,sizeof(matpar));marshalled_dataset+=sizeof(matpar);
	memcpy(&matpar_offset,marshalled_dataset,sizeof(matpar_offset));marshalled_dataset+=sizeof(matpar_offset);
	memcpy(&numparid,marshalled_dataset,sizeof(numparid));marshalled_dataset+=sizeof(numparid);
	memcpy(&numpar,marshalled_dataset,sizeof(numpar));marshalled_dataset+=sizeof(numpar);
	memcpy(&numpar_offset,marshalled_dataset,sizeof(numpar_offset));marshalled_dataset+=sizeof(numpar_offset);
	memcpy(&h,marshalled_dataset,sizeof(h));marshalled_dataset+=sizeof(h);
	memcpy(&k,marshalled_dataset,sizeof(k));marshalled_dataset+=sizeof(k);

	/*nodes and materials are not pointing to correct objects anymore:*/
	node=NULL;
	matice=NULL;
	matpar=NULL;
	numpar=NULL;

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
		
/*Object functions*/
/*FUNCTION Sing::ComputePressure {{{1*/
#undef __FUNCT__ 
#define __FUNCT__ "Sing::ComputePressure"
void  Sing::ComputePressure(Vec p_g){

	int i;
	const int numgrids=1;
	int doflist[numgrids];
	double pressure[numgrids];
	double rho_ice,g;

	/*Get dof list on which we will plug the pressure values: */
	GetDofList1(&doflist[0]);

	/*pressure is lithostatic: */
	rho_ice=matpar->GetRhoIce();
	g=matpar->GetG();
	pressure[0]=rho_ice*g*h;
	
	/*plug local pressure values into global pressure vector: */
	VecSetValues(p_g,numgrids,doflist,(const double*)pressure,INSERT_VALUES);

}
/*}}}*/
/*FUNCTION Sing::Configure {{{1*/
#undef __FUNCT__ 
#define __FUNCT__ "Sing::Configure"
void  Sing::Configure(void* ploadsin, void* pnodesin,void* pmaterialsin,void* pparametersin){

	int i;
	
	DataSet* nodesin=NULL;
	DataSet* materialsin=NULL;
	DataSet* parametersin=NULL;

	/*Recover pointers :*/
	nodesin=(DataSet*)pnodesin;
	materialsin=(DataSet*)pmaterialsin;
	parametersin=(DataSet*)pparametersin;

	/*Link this element with its nodes, ie find pointers to the nodes in the nodes dataset.: */
	ResolvePointers((Object**)&node,&node_id,&node_offset,1,nodesin);
	
	/*Same for materials: */
	ResolvePointers((Object**)&matice,&mid,&matice_offset,1,materialsin);
	ResolvePointers((Object**)&matpar,&mparid,&matpar_offset,1,materialsin);

	/*Same for numpar: */
	ResolvePointers((Object**)&numpar,&numparid,&numpar_offset,1,parametersin);

}
/*}}}*/
/*FUNCTION Sing::copy {{{1*/
Object* Sing::copy() {
	
	return new Sing(*this); 

}
/*}}}*/
/*FUNCTION Sing::CreateKMatrix {{{1*/
#undef __FUNCT__ 
#define __FUNCT__ "Sing::CreateKMatrix"

void  Sing::CreateKMatrix(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type){

	/*Just branch to the correct element stiffness matrix generator, according to the type of analysis we are carrying out: */
	if ((analysis_type==DiagnosticAnalysisEnum()) && (sub_analysis_type==HutterAnalysisEnum())){

		CreateKMatrixDiagnosticHutter( Kgg,inputs,analysis_type,sub_analysis_type);

	}
	else{
		throw ErrorException(__FUNCT__,exprintf("%s%i%s%i%s\n","analysis: ",analysis_type," and sub_analysis_type: ",sub_analysis_type," not supported yet"));
	}

}
/*}}}*/
/*FUNCTION Sing::CreateKMatrixDiagnosticHutter {{{1*/
#undef __FUNCT__ 
#define __FUNCT__ "Sing::CreateKMatrixDiagnosticHutter"

void  Sing::CreateKMatrixDiagnosticHutter(Mat Kgg,void* vinputs,int analysis_type,int sub_analysis_type){
	
	const int numgrids=1;
	const int NDOF2=2;
	const int numdofs=numgrids*NDOF2;
	double Ke_gg[numdofs][numdofs]={{1,0},{0,1}};
	int    doflist[numdofs];
	int    numberofdofspernode;

	ParameterInputs* inputs=NULL;

	/*recover pointers: */
	inputs=(ParameterInputs*)vinputs;
	
	GetDofList(&doflist[0],&numberofdofspernode);

	MatSetValues(Kgg,numdofs,doflist,numdofs,doflist,(const double*)Ke_gg,ADD_VALUES);

}
/*}}}*/
/*FUNCTION Sing::CreatePVector {{{1*/
#undef __FUNCT__ 
#define __FUNCT__ "Sing::CreatePVector"
void  Sing::CreatePVector(Vec pg,void* inputs,int analysis_type,int sub_analysis_type){
	
	/*Just branch to the correct load generator, according to the type of analysis we are carrying out: */
	if ((analysis_type==DiagnosticAnalysisEnum()) && (sub_analysis_type==HutterAnalysisEnum())){
	
			CreatePVectorDiagnosticHutter( pg,inputs,analysis_type,sub_analysis_type);

	}
	else{
		throw ErrorException(__FUNCT__,exprintf("%s%i%s"," analysis ",analysis_type," not supported yet"));
	}

}
/*}}}*/
/*FUNCTION Sing::CreatePVectorDiagnosticHutter {{{1*/
#undef __FUNCT__ 
#define __FUNCT__ "Sing::CreatePVectorDiagnosticHutter"

void Sing::CreatePVectorDiagnosticHutter( Vec pg, void* vinputs, int analysis_type,int sub_analysis_type){
	
	
	const int numgrids=1;
	const int NDOF2=2;
	const int numdofs=NDOF2*numgrids;
	int    doflist[numdofs];
	int       dofs[1]={0};
	int       found=0;
	double    slope[2];
	double    slope2;
	double    pe_g[numdofs]={0,0};
	double    ub,vb;
	double    constant_part;
	int       numberofdofspernode;
	double    rho_ice,gravity,n,B;

	ParameterInputs* inputs=NULL;

	/*recover pointers: */
	inputs=(ParameterInputs*)vinputs;

	found=inputs->Recover("surfaceslopex",&slope[0],1,dofs,numgrids,(void**)&node);
	if(!found)throw ErrorException(__FUNCT__," surfaceslopex missing from inputs!");
	found=inputs->Recover("surfaceslopey",&slope[1],1,dofs,numgrids,(void**)&node);
	if(!found)throw ErrorException(__FUNCT__," surfaceslopey missing from inputs!");

	GetDofList(&doflist[0],&numberofdofspernode);

	//compute slope2 
	slope2=pow(slope[0],2)+pow(slope[1],2);

	//compute ub
	rho_ice=matpar->GetRhoIce();
	gravity=matpar->GetG();
	n=matice->GetN();
	B=matice->GetB();

	ub=-1.58*pow((double)10.0,(double)-10.0)*rho_ice*gravity*h*slope[0];
	vb=-1.58*pow((double)10.0,(double)-10.0)*rho_ice*gravity*h*slope[1];

	//compute constant_part
	constant_part=-2*pow(rho_ice*gravity,n)*pow(slope2,((n-1)/2));

	pe_g[0]=ub-2.0*pow(rho_ice*gravity,n)*pow(slope2,((n-1)/2.0))*pow(h,n)/(pow(B,n)*(n+1))*slope[0];
	pe_g[1]=vb-2.0*pow(rho_ice*gravity,n)*pow(slope2,((n-1)/2.0))*pow(h,n)/(pow(B,n)*(n+1))*slope[1];

	VecSetValues(pg,numdofs,doflist,(const double*)pe_g,ADD_VALUES);


}
/*}}}*/
/*FUNCTION Sing::DeepEcho {{{1*/
#undef __FUNCT__
#define __FUNCT__ "Sing::DeepEcho"
void Sing::DeepEcho(void){

	printf("Sing:\n");
	printf("   id: %i\n",id);
	printf("   mid: %i\n",mid);
	printf("   mparid: %i\n",mparid);
	printf("   node_id=[%i]\n",node_id);
	printf("   node_offset=[%i]\n",node_offset);
	printf("   matice_offset=%i\n",matice_offset);
	printf("   matpar_offset=%i\n",matpar_offset);
	printf("   h=[%g]\n",h);
	printf("   k=[%g]\n",h);
	printf("   node: \n");
	if(node)node->Echo();
	if(matice)matice->Echo();
	if(matpar)matpar->Echo();

	return;
}
/*}}}*/
/*FUNCTION Sing::Du {{{1*/
#undef __FUNCT__ 
#define __FUNCT__ "Sing::Du"
void  Sing::Du(_p_Vec*,void*,int,int){
	throw ErrorException(__FUNCT__," not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::Echo{{{1*/
#undef __FUNCT__
#define __FUNCT__ "Sing::Echo"

void Sing::Echo(void){

	printf("Sing:\n");
	printf("   id: %i\n",id);
	printf("   mid: %i\n",mid);
	printf("   mparid: %i\n",mparid);
	printf("   node_id=[%i]\n",node_id);
	printf("   node_offset=[%i]\n",node_offset);
	printf("   matice_offset=%i\n",matice_offset);
	printf("   matpar_offset=%i\n",matpar_offset);
	printf("   h=[%g]\n",h);
	printf("   k=[%g]\n",h);
	printf("   node: \n");
	if(node)node->Echo();
	if(matice)matice->Echo();
	if(matpar)matpar->Echo();

	return;
}
/*}}}*/
/*FUNCTION Sing::Enum {{{1*/
int Sing::Enum(void){

	return SingEnum();

}
/*}}}*/
/*FUNCTION Sing::GetBedList {{{1*/
#undef __FUNCT__ 
#define __FUNCT__ "Sing::GetBedList"
void  Sing::GetBedList(double*){
	throw ErrorException(__FUNCT__," not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::GetDofList {{{1*/
void  Sing::GetDofList(int* doflist,int* pnumberofdofspernode){

	int i;
	int doflist_per_node[MAXDOFSPERNODE];
	int numberofdofspernode;
	
	node->GetDofList(&doflist_per_node[0],&numberofdofspernode);
	for(i=0;i<numberofdofspernode;i++){
		doflist[i]=doflist_per_node[i];
	}

	/*Assign output pointers:*/
	*pnumberofdofspernode=numberofdofspernode;

}
/*}}}*/
/*FUNCTION Sing::GetDofList1 {{{1*/
void  Sing::GetDofList1(int* doflist){

	int i;
	doflist[0]=node->GetDofList1();

}
/*}}}*/
/*FUNCTION Sing::GetId {{{1*/
int    Sing::GetId(void){ return id; }
/*}}}*/
/*FUNCTION Sing::GetMatPar {{{1*/
void* Sing::GetMatPar(){
	return matpar;
}
/*}}}*/
/*FUNCTION Sing::GetName {{{1*/
char* Sing::GetName(void){
	return "sing";
}
/*}}}*/
/*FUNCTION Sing::GetNodes {{{1*/
void  Sing::GetNodes(void** vpnodes){
	
	Node** pnodes=(Node**)vpnodes;

	pnodes[0]=node;
}
/*}}}*/
/*FUNCTION Sing::GetOnBed {{{1*/
#undef __FUNCT__ 
#define __FUNCT__ "Sing::GetOnBed"
int   Sing::GetOnBed(){
	throw ErrorException(__FUNCT__," not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::GetShelf {{{1*/
#undef __FUNCT__ 
#define __FUNCT__ "Sing::GetShelf"
int   Sing::GetShelf(){
	throw ErrorException(__FUNCT__," not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::GetThicknessList {{{1*/
#undef __FUNCT__ 
#define __FUNCT__ "Sing::GetThicknessList"
void  Sing::GetThicknessList(double* thickness_list){
	throw ErrorException(__FUNCT__," not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::Gradj {{{1*/
#undef __FUNCT__ 
#define __FUNCT__ "Sing::Gradj"
void  Sing::Gradj(_p_Vec*, void*, int, int ,char*){
	throw ErrorException(__FUNCT__," not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::GradB {{{1*/
#undef __FUNCT__ 
#define __FUNCT__ "Sing::GradjB"
void  Sing::GradjB(_p_Vec*, void*, int,int){
	throw ErrorException(__FUNCT__," not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::GradjDrag {{{1*/
#undef __FUNCT__ 
#define __FUNCT__ "Sing::GradjDrag"
void  Sing::GradjDrag(_p_Vec*, void*, int,int){
	throw ErrorException(__FUNCT__," not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::MassFlux {{{1*/
#undef __FUNCT__ 
#define __FUNCT__ "Sing::MassFlux"
double Sing::MassFlux( double* segment,double* ug){
	throw ErrorException(__FUNCT__," not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::MaticeConfiguration {{{1*/
#undef __FUNCT__ 
#define __FUNCT__ "Sing::MaticeConfiguration"
void  Sing::MaticeConfiguration(Matice* sing_matice,int sing_matice_offset){
	matice=sing_matice;
	matice_offset=sing_matice_offset;
}
/*}}}*/
/*FUNCTION Sing::MatparConfiguration {{{1*/
#undef __FUNCT__ 
#define __FUNCT__ "Sing::MatparConfiguration"
void  Sing::MatparConfiguration(Matpar* sing_matpar,int sing_matpar_offset){

	matpar=sing_matpar;
	matpar_offset=sing_matpar_offset;

}
/*}}}*/
/*FUNCTION Sing::Misfit {{{1*/
#undef __FUNCT__ 
#define __FUNCT__ "Sing::Misfit"
double Sing::Misfit(void*, int,int,int){
	throw ErrorException(__FUNCT__," not supported yet!");
}
/*}}}*/
/*FUNCTION Sing::MyRank {{{1*/
int    Sing::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION Sing::UpdateFromInputs {{{1*/
#undef __FUNCT__ 
#define __FUNCT__ "Sing::UpdateFromInputs"
void  Sing::UpdateFromInputs(void* vinputs){

	int     dofs[1]={0};
	double  temperature;
	double  B;

	ParameterInputs* inputs=NULL;

	/*recover pointers: */
	inputs=(ParameterInputs*)vinputs;

	/*Update internal data if inputs holds new values: */
	inputs->Recover("thickness",&h,1,dofs,1,(void**)&node);
	inputs->Recover("drag",&k,1,dofs,1,(void**)&node);
	
	//Update material if necessary
	if(inputs->Recover("temperature_average",&temperature,1,dofs,1,(void**)&node)){
		B=Paterson(temperature);
		matice->SetB(B);
	}
	if(inputs->Recover("temperature",&temperature,1,dofs,1,(void**)&node)){
		B=Paterson(temperature);
		matice->SetB(B);
	}
	
	if(inputs->Recover("B",&B,1,dofs,1,(void**)&node)){
		matice->SetB(B);
	}

}
/*}}}*/
