/*\file ComputePressure.c
 *\brief: recover pressure from elements
 */

#include "./ComputePressure.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	int      numberofnodes;

	/* output datasets: */
	Vec p_g=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ComputePressureUsage);
        
	/*Input datasets: */
	FetchData((void**)&elements,NULL,NULL,ELEMENTS,"DataSet",NULL);
	FetchData((void**)&nodes,NULL,NULL,NODES,"DataSet",NULL);
	FetchData((void**)&loads,NULL,NULL,LOADS,"DataSet",NULL);
	FetchData((void**)&materials,NULL,NULL,MATERIALS,"DataSet",NULL);
	FetchData((void**)&numberofnodes,NULL,NULL,mxGetField(PARAMS,0,"numberofnodes"),"Integer",NULL);

	/*!Generate internal degree of freedom numbers: */
	ComputePressurex(&p_g, elements,nodes,loads,materials,numberofnodes);

	/*write output datasets: */
	WriteData(PRESSURE,p_g,0,0,"Vector",NULL);

	/*Free ressources: */
	delete nodes;
	delete elements;
	delete materials;
	delete loads;
	VecFree(&p_g);

	/*end module: */
	MODULEEND();
}

void ComputePressureUsage(void) {
	_printf_("\n");
	_printf_("   usage: [p_g] = %s(elements, nodes, loads, materials, params);\n",__FUNCT__);
	_printf_("\n");
}
