/*!\file ComputePressurex
 * \brief: compute pressure according to each element
 */

#include "./ComputePressurex.h"

#undef __FUNCT__ 
#define __FUNCT__ "ComputePressurex"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void	ComputePressurex( Vec* pp_g,DataSet* elements,DataSet* nodes,DataSet* loads, DataSet* materials, int numberofnodes){

	int i;

	int  found=0;

	/*output: */
	Vec p_g=NULL;

	/*Allocate p_g on numberofnodes (only 1 dof): */
	p_g=NewVec(numberofnodes);

	/*Get elements configured: */
	elements->Configure(elements,loads, nodes, materials);

	/*Call on dataset driver: */
	elements->ComputePressure(p_g);

	/*Assemble vector: */
	VecAssemblyBegin(p_g);
	VecAssemblyEnd(p_g);

	/*Assign output pointers: */
	*pp_g=p_g;
	
}
