function [flags middles]=flagedges(x,y,partition,adjacencymatrix);
%FLAGEDGES return a vector of boolean flags that indicate whether a node is on the edge of a partition.
%          needs partition vector and adjacencymatrix in inputs.
%
%
%         Usage: [flags middlegrids]=flagedges(x,y,partition,adjacencymatrix);
%

%number of grids
numberofgrids=length(partition);

%initialize flags
flags=zeros(numberofgrids,1);

middles=zeros(0,2);

%go through grids, and figure out which grid is connected to a grid belonging to another partition, flag it.
for i=1:numberofgrids,

	%some feedback
	if i==1,
		fprintf('    flagedges progress report: %5.2f %s',i/numberofgrids*100,'%');
	elseif mod(i,1000),
		fprintf('\b\b\b\b\b\b\b');
		fprintf('%5.2f %s',i/numberofgrids*100,'%');
	end

	%already flag, move on
	if flags(i),
		continue;
	end
	
	grids=adjacencymatrix(:,i); grids=find(grids);
	
	part_i=partition(i);
	part_connected=partition(grids);

	index=find(part_i~=part_connected);
	if ~isempty(index),
		grids_on_edge=grids(index);
		flags(grids_on_edge)=1;
		flags(i)=1; 
		for j=1:length(grids_on_edge),
			middles(end+1,:)=[(x(grids_on_edge(j))+x(i))/2 (y(grids_on_edge(j))+y(i))/2];
		end
	end
end
