function md=adjacency(md);
%adjacency:  compute adjacency matrix, list of vertices and list of weights.
%
%  function to create the adjacency matrix from the connectivity table.
%
%  the required output is:
%    md.adj_mat     (double [sparse nv x nv], vertex adjacency matrix)
%    md.vwgt        (double [nv], vertex weights)



indi=[md.elements(:,1);md.elements(:,2);md.elements(:,3)];
indj=[md.elements(:,2);md.elements(:,3);md.elements(:,1)];
values=1;

md.adjacency=sparse(indi,indj,values,md.numberofgrids,md.numberofgrids);
md.adjacency=[md.adjacency | md.adjacency'];

%now, build vwgt:
areas=GetAreas(md.elements,md.x,md.y);
connectivity=md.nodeconnectivity(:,1:end-1);
pos=find(connectivity);
connectivity(pos)=areas(connectivity(pos))/3;
md.vwgt=sum(connectivity,2);
