#!/bin/bash

# Some cleanup
rm -rf meshpart
rm -rf src 
rm -rf install 

# Create src and install directories
mkdir src install 

# Untar 
tar -xvzf meshpart-020208.tar.gz
mkdir meshpart/metis
tar -xvzf metismex-4.0.tar.gz -C meshpart/metis
#proto.h in metis library is not patched, at least for metismex, so create a local version
cp ../metis/install/Lib/proto.h meshpart/metis

# Move meshpart to src directory
mv meshpart/* src
rm -rf meshpart

# Apply patches (all at once)
# (written by diff -rc src ~/Libs/meshpart > meshpart.patch)
patch -p0 < meshpart.patch

#Nothing to build for meshpart itself

#Build metismex
cd src/metis
#proto.h in metis library is not patched, at least for metismex, so link with local version
#mex -I../../../metis/install/Lib -L../../../metis/install -lmetis -largeArrayDims metismex.c
mex -I. -I../../../metis/install/Lib -L../../../metis/install -lmetis -largeArrayDims metismex.c
mv metismex.mex* ..
cd ../..

#Build mlchaco
cd src/chaco
make
#Clean up, specifically the objects left in the chaco directories by mlchaco
make clean
cd ../..

