/*!\file:  CreateLoads.cpp
 * \brief create loads datasets. General driver.
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#undef __FUNCT__ 
#define __FUNCT__ "CreateLoads"

#include "./Model.h"
#include "../shared/shared.h"

void CreateLoads(DataSet** ploads, Model* model,ConstDataHandle model_handle){

	/*This is just a high level driver: */
	if ((strcmp(model->analysis_type,"diagnostic_horiz")==0)|| (strcmp(model->analysis_type,"control")==0)){

		CreateLoadsDiagnosticHoriz(ploads,model,model_handle);
	}
	else if (strcmp(model->analysis_type,"diagnostic_vert")==0){

		CreateLoadsDiagnosticVert(ploads,model,model_handle);
	}
	else if (strcmp(model->analysis_type,"diagnostic_stokes")==0){

		CreateLoadsDiagnosticStokes(ploads,model,model_handle);
	}
	else if (strcmp(model->analysis_type,"diagnostic_hutter")==0){

		CreateLoadsDiagnosticHutter(ploads,model,model_handle);
	}
	else if (strcmp(model->analysis_type,"surface_slope_compute")==0){

		CreateLoadsSurfaceSlopeCompute(ploads,model,model_handle);
	}
	else if (strcmp(model->analysis_type,"bed_slope_compute")==0){

		CreateLoadsBedSlopeCompute(ploads,model,model_handle);
	}
	/*
	else if (strcmp(model->analysis_type,"melting")==0){

		CreateLoadsMelting(ploads,model,model_handle);
	}
	else if (strcmp(model->analysis_type,"prognostic")==0){

		CreateLoadsPrognostic(ploads,model,model_handle);
	}
	else if ((strcmp(model->analysis_type,"thermalsteady")==0) || (strcmp(model->analysis_type,"thermaltransient")==0)){
	
		CreateLoadsThermal(ploads,model,model_handle);

	}*/
	else{
		throw ErrorException(__FUNCT__," analysis_type not supported yet!");
	}
}
