function []=part_hist(maptab,wgt);

if (size(maptab,1) > size(maptab,2))
    map=maptab(:,end);
else
    map=maptab(end,:)';
end

imin=min(map);
imax=max(map);

part=zeros(imax-imin+1,2);

for i=imin:imax
    ind=find(map == i);
    part(i-imin+1,1)=length(ind);
    if exist('wgt','var')
        part(i-imin+1,2)=sum(wgt(ind));
    else
        part(i-imin+1,2)=part(i-imin+1,1);
    end
end

figure
subplot(2,1,1)
bar(imin:imax,part(:,1));
xlim([imin imax])
title('Number of Nodes in Each Partition')

subplot(2,1,2)
bar(imin:imax,part(:,2));
xlim([imin imax])
title('Weight of Nodes in Each Partition')

end
