#!/bin/bash

# Some cleanup
rm -rf scotch_5.1
rm -rf src 
rm -rf install 

# Create src and install directories
mkdir src install 

# Untar 
tar -xvzf scotch_5.1.6.tar.gz

# Move scotch to src directory
mv scotch_5.1/* src
rm -rf scotch_5.1

# Apply patches (all at once, since many)
# (written by diff -rc src ~/Libs/scotch_5.1 > scotch.patch)
patch -p0 < scotch.patch

# Build scotch
cp Makefile.inc src/src
cp gmap_mex.c src/src/scotch
cd src/src
make mexscotch
# For stand-alone scotch modules, also execute below
#make
# Clean up
make clean
cd ../..

