#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=`grep -c processor /proc/cpuinfo`;

#version of mpich2
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/mpich2-//g'`

#Some cleanup
rm -rf src install mpich2-$version

#Create src and install directories
mkdir src install

#Untar 
tar -zxvf  mpich2-$version.tar.gz

#Move mpich2 into src directory
mv mpich2-$version/* src
rm -rf mpich2-$version

#Configure mpich2
cd src
./configure --prefix="$ISSM_DIR/externalpackages/mpich2/install" --enable-sharedlibs=gcc --enable-f91=gfortran 

#Apply Patch to examples
patch ./examples/Makefile ../Examples.Makefile.patch
patch -R ./src/binding/cxx/mpicxx.h ../mpicxx.h.patch
patch -R ./src/include/mpicxx.h ../mpicxx.h.patch

#Compile mpich2
make  

#Install
make install
