%  create adjacency matrix, vertex list, and vertex weights
[adj_mat,vlist,vwgt]=adjacency_matrix(md.elements,[md.x md.y md.z]);

%  add integer scaled vertex weights into adjacency matrix for chaco (on diagonal)
adj_mat2=adj_mat+sparse(1:size(adj_mat,1),1:size(adj_mat,2),floor(vwgt/min(vwgt)));

%  default method (from chaco.m)
method=[1 1 0 0 1 1 50 0 .001 7654321];
method(1)=3;    %  global method (3=inertial (geometric))
method(3)=1;    %  vertex weights (0=off, 1=on)
method(6)=1;    %  ndims (1=bisection, 2=quadrisection, 3=octasection)

%  partition into 100 parts
[map]=chaco(adj_mat2,[md.x md.y],method,100); 
%adj_mat: don't use the weights
%adj_mat2: use the weights

error;

%  plot partitions
figure
plotmodel(md,'data',map)

%  plot histograms of number and weight of vertices in each partition
figure
part_hist([(1:length(map))' map'],vwgt)
