function flag=FlagElements(md,area),
%FLAGELEMENTS - flag the elements in an area
%
%   The area can be given with an exp file, a list of elements.
%
%   Usage: 
%      flag=FlagElements(md,area);
%
%   Example:
%      flag=FlagElements(md,'all');
%      flag=FlagElements(md,'');
%      flag=FlagElements(md,'Domain.exp');
%      flag=FlagElements(md,'~Domain.exp');
%      flag=FlagElements(md,md.elementonicesheet);

	if ischar(area),
		if isempty(area),
			flag=zeros(md.numberofelements,1);
			invert=0;
		elseif strcmpi(area,'all')
			flag=ones(md.numberofelements,1);
			invert=0;
		else
			%make sure that we actually don't want the elements outside the domain outline!
			if strcmpi(area(1),'~'),
				area=area(2:length(area));
				invert=1;
			else
				invert=0;
			end

			%does the area domain outline exist or do we have to look for xlim,ylim in basinzoom?
			if ~exist(area,'file'),
				[xlim,ylim]=basinzoom(area)
				flag_nodes=double(md.x<xlim(2) & md.x>xlim(1) &  md.y<ylim(2) & md.y>ylim(1));
				flag=prod(flag_nodes(md.elements),2);
			else
				%ok, flag elements
				flag=ContourToMesh(md.elements(:,1:3),md.x,md.y,expread(area,1),'element',1);
			end
		end
		if invert,
			flag=~flag;
		end
	elseif isfloat(area),
		if size(area,1)~=md.numberofelements,
			setelementstypeusage();
			error('Flaglist for area must be of same size as number of elements in model');
		end
		flag=area;
	else
		error('Invalid area option option');
	end
end
